/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.ter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import growthcraft.cellar.common.tileentity.CultureJarTileEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class CultureJarTileEntityRenderer
extends TileEntityRenderer<CultureJarTileEntity> {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public CultureJarTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(CultureJarTileEntity te) {
        return true;
    }

    public void render(CultureJarTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightLevel, int overlay) {
        if (tileEntity.getInputFluidTank(0).isEmpty()) {
            return;
        }
        FluidStack inputFluidStack = tileEntity.getInputFluidTank(0).getFluid();
        float capacity = tileEntity.getInputFluidTank(0).getCapacity();
        float amount = inputFluidStack.getAmount();
        float inputFluidHeight = amount / capacity;
        this.renderCubeUsingQuads(tileEntity, partialTicks, matrixStack, buffer, inputFluidStack, inputFluidHeight, lightLevel, overlay);
    }

    public void renderCubeUsingQuads(CultureJarTileEntity cultureJarTileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, FluidStack fluidStack, float inputFluidHeight, int lightLevel, int overlay) {
        Vector3d TRANSLATION_OFFSET = new Vector3d(0.0, 0.01, 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(TRANSLATION_OFFSET.field_72450_a, TRANSLATION_OFFSET.field_72448_b, TRANSLATION_OFFSET.field_72449_c);
        FluidAttributes fluidAttributes = fluidStack.getFluid().getAttributes();
        Color color = new Color(fluidAttributes.getColor(fluidStack));
        TextureAtlasSprite fluidStillTexture = (TextureAtlasSprite)this.minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidAttributes.getStillTexture(fluidStack));
        this.drawCubeQuads(matrixStack, renderTypeBuffer, inputFluidHeight, fluidStillTexture, color, lightLevel);
        matrixStack.func_227865_b_();
    }

    private void drawCubeQuads(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float inputFluidHeight, TextureAtlasSprite textureAtlasSprite, Color color, int lightLevel) {
        IVertexBuilder vertexBuilderBlockQuads = renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("growthcraft_cellar:textures/block/fluid/fluid_still.png")));
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f matrixNormal = matrixStack.func_227866_c_().func_227872_b_();
        Vector2f bottomLeftUV = new Vector2f(0.0f, 1.0f);
        float uVwidth = 1.0f;
        float uVheight = 1.0f;
        float WIDTH = 0.25f;
        float HEIGHT = 0.25f;
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(0.375, 0.125 * (double)inputFluidHeight, 0.5);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.625, 0.125 * (double)inputFluidHeight, 0.5);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.5, 0.125 * (double)inputFluidHeight, 0.375);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.5, 0.125 * (double)inputFluidHeight, 0.625);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.5, 0.25 * (double)inputFluidHeight, 0.5);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.5, 0.0, 0.5);
        this.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 0.25f, 0.25f * inputFluidHeight, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
        this.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 0.25f, 0.25f * inputFluidHeight, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
        this.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 0.25f, 0.25f * inputFluidHeight, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
        this.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 0.25f, 0.25f * inputFluidHeight, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
        this.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 0.25f, 0.25f, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
        this.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 0.25f, 0.25f, textureAtlasSprite, bottomLeftUV, uVwidth, uVheight, lightLevel);
    }

    private void addFace(Direction face, Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder vertexBuilderBlockQuads, Color color, Vector3d centrePos, float width, float height, TextureAtlasSprite textureAtlasSprite, Vector2f bottomLeftUV, float uVwidth, float uVheight, int lightLevel) {
        Vector3f bottomToTopDirection;
        Vector3f leftToRightDirection;
        switch (face) {
            case NORTH: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case EAST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case UP: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case DOWN: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
            }
        }
        leftToRightDirection.func_195898_a(0.5f * width);
        bottomToTopDirection.func_195898_a(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f(centrePos);
        bottomLeftPos.func_195897_a(leftToRightDirection);
        bottomLeftPos.func_195897_a(bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f(centrePos);
        bottomRightPos.func_229189_a_(leftToRightDirection);
        bottomRightPos.func_195897_a(bottomToTopDirection);
        Vector3f topRightPos = new Vector3f(centrePos);
        topRightPos.func_229189_a_(leftToRightDirection);
        topRightPos.func_229189_a_(bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f(centrePos);
        topLeftPos.func_195897_a(leftToRightDirection);
        topLeftPos.func_229189_a_(bottomToTopDirection);
        Vector3f normalVector = face.func_229386_k_();
        this.addQuad(matrixPos, matrixNormal, vertexBuilderBlockQuads, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, normalVector, textureAtlasSprite, color, lightLevel);
    }

    private void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f bottomLeftPos, Vector3f bottomRightPos, Vector3f topRightPos, Vector3f topLeftPos, Vector3f normalVector, TextureAtlasSprite textureAtlasSprite, Color color, int lightLevel) {
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, bottomLeftPos, normalVector, textureAtlasSprite, color, lightLevel);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, bottomRightPos, normalVector, textureAtlasSprite, color, lightLevel);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, topRightPos, normalVector, textureAtlasSprite, color, lightLevel);
        this.addQuadVertex(matrixPos, matrixNormal, renderBuffer, topLeftPos, normalVector, textureAtlasSprite, color, lightLevel);
    }

    private void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f topLeftPos, Vector3f normalVector, TextureAtlasSprite textureAtlasSprite, Color color, int lightLevel) {
        renderBuffer.func_227888_a_(matrixPos, topLeftPos.func_195899_a(), topLeftPos.func_195900_b(), topLeftPos.func_195902_c()).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_(textureAtlasSprite.func_94212_f(), textureAtlasSprite.func_94206_g()).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightLevel).func_225584_a_(normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
    }
}

