/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.compat.jei;

import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.compat.jei.category.BrewKettleRecipeCategory;
import growthcraft.cellar.compat.jei.category.CultureJarRecipeCategory;
import growthcraft.cellar.compat.jei.category.FermentBarrelRecipeCategory;
import growthcraft.cellar.compat.jei.category.FruitPressRecipeCategory;
import growthcraft.cellar.compat.jei.category.RoasterRecipeCategory;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.lib.util.RecipeUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

@JeiPlugin
public class GrowthcraftCellarJeiPlugin
implements IModPlugin {
    public void registerIngredients(IModIngredientRegistration registry) {
        GrowthcraftCellar.LOGGER.log(Level.DEBUG, "{} registering JEI ingredients.", (Object)"growthcraft_cellar");
        super.registerIngredients(registry);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        GrowthcraftCellar.LOGGER.log(Level.DEBUG, "{} registering JEI Recipes.", (Object)"growthcraft_cellar");
        registry.addRecipes(RecipeUtils.findRecipesByType(GrowthcraftCellarRecipes.BREW_KETTLE_RECIPE_TYPE), BrewKettleRecipeCategory.ID);
        registry.addRecipes(RecipeUtils.findRecipesByType(GrowthcraftCellarRecipes.CULTURE_JAR_RECIPE_TYPE), CultureJarRecipeCategory.ID);
        registry.addRecipes(RecipeUtils.findRecipesByType(GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE), FermentBarrelRecipeCategory.ID);
        registry.addRecipes(RecipeUtils.findRecipesByType(GrowthcraftCellarRecipes.FRUIT_PRESS_RECIPE_TYPE), FruitPressRecipeCategory.ID);
        registry.addRecipes(RecipeUtils.findRecipesByType(GrowthcraftCellarRecipes.ROASTER_RECIPE_TYPE), RoasterRecipeCategory.ID);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        GrowthcraftCellar.LOGGER.log(Level.DEBUG, "{} registering JEI categories.", (Object)"growthcraft_cellar");
        registry.addRecipeCategories(new IRecipeCategory[]{new BrewKettleRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new FermentBarrelRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new FruitPressRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CultureJarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RoasterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("growthcraft_cellar", "jei");
    }
}

