/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import growthcraft.milk.client.container.MixingVatContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class MixingVatScreen
extends ContainerScreen<MixingVatContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_milk", "mixing_vat");

    public MixingVatScreen(MixingVatContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        MixingVatScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiProgressX = this.field_147003_i + 99;
        int guiProgressY = this.field_147009_r + 21;
        this.func_238474_b_(matrixStack, guiProgressX, guiProgressY, 177, 43, 13, ((MixingVatContainer)this.field_147002_h).getProgressionScaled(28));
        int guiHeatLevelX = this.field_147003_i + 98;
        int guiHeatLevelY = this.field_147009_r + 56;
        if (((MixingVatContainer)this.field_147002_h).isBurning()) {
            this.func_238474_b_(matrixStack, guiHeatLevelX, guiHeatLevelY, 176, 28, 13, 13);
        }
        int guiInputTankX = this.field_147003_i + 49;
        int guiInputTankY = this.field_147009_r + 32;
        int guiInputTankHeight = 37;
        if (((MixingVatContainer)this.field_147002_h).getInputFluidTank().getFluidAmount() > 0) {
            FluidStack fluidStack = ((MixingVatContainer)this.field_147002_h).getInputFluidTank().getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((MixingVatContainer)this.field_147002_h).getInputFluidTank().getCapacity(), guiInputTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiInputTankX, guiInputTankY + (guiInputTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        int guiReagentTankX = this.field_147003_i + 49;
        int guiReagentTankY = this.field_147009_r + 18;
        int guiReagentTankHeight = 10;
        if (((MixingVatContainer)this.field_147002_h).getReagentFluidTank().getFluidAmount() > 0) {
            FluidStack fluidStack = ((MixingVatContainer)this.field_147002_h).getReagentFluidTank().getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((MixingVatContainer)this.field_147002_h).getReagentFluidTank().getCapacity(), guiReagentTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiReagentTankX, guiReagentTankY + (guiReagentTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        renderTypeBuffer.func_228461_a_();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiInputTankX = this.field_147003_i + 49;
        int guiInputTankY = this.field_147009_r + 32;
        int guiInputTankHeight = 37;
        if (mouseX > guiInputTankX && mouseX < guiInputTankX + 16 && mouseY > guiInputTankY && mouseY < guiInputTankY + guiInputTankHeight) {
            FluidStack fluidStack = ((MixingVatContainer)this.field_147002_h).getInputFluidTank().getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        int guiReagentTankX = this.field_147003_i + 49;
        int guiReagentTankY = this.field_147009_r + 18;
        int guiReagentTankHeight = 10;
        if (mouseX > guiReagentTankX && mouseX < guiReagentTankX + 16 && mouseY > guiReagentTankY && mouseY < guiReagentTankY + guiReagentTankHeight) {
            FluidStack fluidStack = ((MixingVatContainer)this.field_147002_h).getReagentFluidTank().getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        int guiOutputTankX = this.field_147003_i + 124;
        int guiOutputTankY = this.field_147009_r + 40;
        int guiOutputTankHeight = 29;
        if (mouseX > guiOutputTankX && mouseX < guiOutputTankX + 16 && mouseY > guiOutputTankY && mouseY < guiOutputTankY + guiOutputTankHeight) {
            FluidStack fluidStack = ((MixingVatContainer)this.field_147002_h).getOutputFluidTank().getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }
}

