/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import growthcraft.lib.util.CraftingUtils;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.recipe.MixingVatFluidRecipe;
import growthcraft.milk.common.recipe.MixingVatItemRecipe;
import growthcraft.milk.common.recipe.MixingVatRecipe;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MixingVatRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<MixingVatRecipe> {
    private static final int maxIngredients = 3;

    public MixingVatRecipe read(ResourceLocation recipeId, JsonObject json) {
        MixingVatRecipe.MixingVatRecipeCategory category = MixingVatRecipe.MixingVatRecipeCategory.with(JSONUtils.func_151200_h((JsonObject)json, (String)"result_type"));
        int processingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"processing_time", (int)1200);
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        ItemStack activationTool = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"activation_tool"), (boolean)false);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        JsonArray jsonIngredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
        if (jsonIngredients.size() <= 3) {
            for (int i = 0; i < jsonIngredients.size(); ++i) {
                ItemStack itemStack = CraftingHelper.getItemStack((JsonObject)jsonIngredients.get(i).getAsJsonObject(), (boolean)false);
                ingredients.add(itemStack);
            }
        }
        if (category == MixingVatRecipe.MixingVatRecipeCategory.ITEM) {
            ItemStack resultItemStack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result_item"), (boolean)false);
            ItemStack resultActivationTool = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result_activation_tool"), (boolean)false);
            return new MixingVatItemRecipe(recipeId, MixingVatRecipe.MixingVatRecipeCategory.ITEM, inputFluid, ingredients, processingTime, resultItemStack, activationTool, resultActivationTool);
        }
        if (category == MixingVatRecipe.MixingVatRecipeCategory.FLUID) {
            FluidStack reagentFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"reagent_fluid"));
            FluidStack resultFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"result_fluid"));
            FluidStack wasteFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"result_fluid_waste"));
            return new MixingVatFluidRecipe(recipeId, MixingVatRecipe.MixingVatRecipeCategory.FLUID, inputFluid, reagentFluid, ingredients, processingTime, resultFluid, wasteFluid, activationTool);
        }
        return null;
    }

    @Nullable
    public MixingVatRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            MixingVatRecipe.MixingVatRecipeCategory category = MixingVatRecipe.MixingVatRecipeCategory.with(buffer.func_218666_n());
            int processingTime = buffer.func_150792_a();
            FluidStack inputFluidStack = buffer.readFluidStack();
            ItemStack activationTool = buffer.func_150791_c();
            int ingredientSize = buffer.func_150792_a();
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            for (int i = 0; i < ingredientSize; ++i) {
                ingredients.add(buffer.func_150791_c());
            }
            if (category == MixingVatRecipe.MixingVatRecipeCategory.ITEM) {
                ItemStack resultingItemStack = buffer.func_150791_c();
                ItemStack resultActivationTool = buffer.func_150791_c();
                return new MixingVatItemRecipe(recipeId, category, inputFluidStack, ingredients, processingTime, resultingItemStack, activationTool, resultActivationTool);
            }
            if (category == MixingVatRecipe.MixingVatRecipeCategory.FLUID) {
                FluidStack reagentFluidStack = buffer.readFluidStack();
                FluidStack outputFluidStack = buffer.readFluidStack();
                FluidStack wasteFluidStack = buffer.readFluidStack();
                return new MixingVatFluidRecipe(recipeId, category, inputFluidStack, reagentFluidStack, ingredients, processingTime, outputFluidStack, wasteFluidStack, activationTool);
            }
        }
        catch (Exception ex) {
            String message = String.format("Unable to read recipe (%s) from network buffer.", recipeId);
            GrowthcraftMilk.LOGGER.error(message);
            throw ex;
        }
        return null;
    }

    public void write(PacketBuffer buffer, MixingVatRecipe recipe) {
        buffer.func_180714_a(recipe.getCategory().toString());
        buffer.func_150787_b(recipe.getProcessingTime());
        buffer.writeFluidStack(recipe.getInputFluidStack());
        buffer.func_150788_a(recipe.getActivationTool());
        buffer.func_150787_b(recipe.getIngredientList().size());
        for (int i = 0; i < recipe.getIngredientList().size(); ++i) {
            buffer.func_150788_a(recipe.getIngredientList().get(i));
        }
        if (recipe.getCategory() == MixingVatRecipe.MixingVatRecipeCategory.ITEM) {
            MixingVatItemRecipe itemRecipe = (MixingVatItemRecipe)recipe;
            buffer.func_150788_a(itemRecipe.getResultItemStack());
            buffer.func_150788_a(itemRecipe.getResultActivationTool());
        }
        if (recipe.getCategory() == MixingVatRecipe.MixingVatRecipeCategory.FLUID) {
            MixingVatFluidRecipe fluidRecipe = (MixingVatFluidRecipe)recipe;
            buffer.writeFluidStack(fluidRecipe.getReagentFluidStack());
            buffer.writeFluidStack(fluidRecipe.getOutputFluidStack());
            buffer.writeFluidStack(fluidRecipe.getWasteFluidStack());
        }
    }
}

