/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.lib.common.tank.handler.FluidTankHandler;
import growthcraft.lib.util.BlockStateUtils;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.client.container.MixingVatContainer;
import growthcraft.milk.common.recipe.MixingVatFluidRecipe;
import growthcraft.milk.common.recipe.MixingVatItemRecipe;
import growthcraft.milk.common.recipe.MixingVatRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class MixingVatTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int INPUT_INVENTORY_SLOTS = 3;
    private final GrowthcraftItemHandler inventory = new GrowthcraftItemHandler(4, new ItemStack[0]);
    private boolean activated = false;
    private ItemStack activationTool;
    private int currentProcessingTime;
    private MixingVatRecipe currentRecipe;
    private ITextComponent customName;
    private boolean heated = false;
    private FluidTankHandler inputFluidTankHandler;
    private int maxProcessingTime;
    private FluidTankHandler outputFluidTankHandler;
    private ItemStack resultActivationTool;

    public MixingVatTileEntity() {
        this((TileEntityType)GrowthcraftMilkTileEntities.MIXING_VAT_TILE_ENTITY.get());
    }

    public MixingVatTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.createFluidTanks();
    }

    private void createFluidTanks() {
        this.inputFluidTankHandler = new FluidTankHandler(1, 4000);
        this.outputFluidTankHandler = new FluidTankHandler(1, 1000);
    }

    public FluidTank getFluidTank(int slot) {
        switch (slot) {
            case 0: {
                return this.inputFluidTankHandler.getTank(0);
            }
            case 1: {
                return this.inputFluidTankHandler.getTank(0);
            }
            case 2: {
                return this.outputFluidTankHandler.getTank(0);
            }
        }
        return null;
    }

    public void func_73660_a() {
        try {
            if (!this.field_145850_b.field_72995_K) {
                if (!this.inputFluidTankHandler.getTank(0).isEmpty() && this.isHeated() && !this.outputFluidTankHandler.getTank(0).isEmpty() && this.inventory.getStackInSlot(3).func_190926_b()) {
                    if (this.checkCurrentRecipe()) {
                        if (this.activated) {
                            ++this.currentProcessingTime;
                        }
                        if (this.currentProcessingTime >= this.maxProcessingTime) {
                            this.processCurrentRecipe();
                        }
                    }
                } else if (!this.inputFluidTankHandler.getTank(0).isEmpty() && this.outputFluidTankHandler.getTank(0).isEmpty() && !this.inventory.getStackInSlot(0).func_190926_b()) {
                    if (this.checkCurrentRecipe()) {
                        if (this.activated) {
                            ++this.currentProcessingTime;
                        }
                        if (this.currentProcessingTime >= this.maxProcessingTime) {
                            this.processCurrentRecipe();
                        }
                    }
                } else if (this.inputFluidTankHandler.getTank(0).isEmpty() && this.outputFluidTankHandler.getTank(0).isEmpty() && !this.inventory.getStackInSlot(3).func_190926_b()) {
                    this.checkCurrentRecipe();
                } else {
                    this.resetAllProcessing();
                }
            }
        }
        catch (Exception ex) {
            GrowthcraftMilk.LOGGER.error("MixingVatTileEntity threw an exception during ticking.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkCurrentRecipe() {
        ArrayList<ItemStack> currentItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            currentItems.add(this.inventory.getStackInSlot(i));
        }
        MixingVatRecipe recipe = null;
        if (!currentItems.isEmpty()) {
            MixingVatRecipe.MixingVatRecipeCategory category = !this.outputFluidTankHandler.getTank(0).isEmpty() ? MixingVatRecipe.MixingVatRecipeCategory.FLUID : MixingVatRecipe.MixingVatRecipeCategory.ITEM;
            if (category == MixingVatRecipe.MixingVatRecipeCategory.ITEM) {
                recipe = this.getItemRecipe(this.inputFluidTankHandler.getTank(0).getFluid(), currentItems);
            }
            if (category == MixingVatRecipe.MixingVatRecipeCategory.FLUID) {
                recipe = this.getFluidRecipe(this.inputFluidTankHandler.getTank(0).getFluid(), this.outputFluidTankHandler.getTank(0).getFluid(), currentItems);
            }
            if (recipe != null) {
                if (recipe == this.currentRecipe) return true;
                this.currentRecipe = recipe;
                this.currentProcessingTime = 0;
                this.maxProcessingTime = recipe.getProcessingTime();
                this.activationTool = recipe.getActivationTool();
            }
        } else {
            MixingVatItemRecipe itemRecipe = this.getRecipeByResult(this.inventory.getStackInSlot(3));
            if (itemRecipe != null) {
                this.resultActivationTool = itemRecipe.getResultActivationTool();
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        return false;
    }

    private void processCurrentRecipe() {
        MixingVatRecipe.MixingVatRecipeCategory category = this.currentRecipe.getCategory();
        List<ItemStack> ingredients = this.currentRecipe.getIngredientList();
        if (category == MixingVatRecipe.MixingVatRecipeCategory.FLUID) {
            MixingVatFluidRecipe fluidRecipe = (MixingVatFluidRecipe)this.currentRecipe;
            this.inputFluidTankHandler.getTank(0).drain(fluidRecipe.getInputFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.outputFluidTankHandler.getTank(0).drain(fluidRecipe.getReagentFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.inputFluidTankHandler.getTank(0).setFluid(fluidRecipe.getOutputFluidStack());
            this.outputFluidTankHandler.getTank(0).setFluid(fluidRecipe.getWasteFluidStack());
        } else if (category == MixingVatRecipe.MixingVatRecipeCategory.ITEM) {
            MixingVatItemRecipe itemRecipe = (MixingVatItemRecipe)this.currentRecipe;
            ItemStack recipeResultItemStack = itemRecipe.getResultItemStack();
            this.inputFluidTankHandler.getTank(0).drain(itemRecipe.getInputFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.getInventory().insertItem(3, recipeResultItemStack, false);
        }
        for (ItemStack itemStack : ingredients) {
            for (int i = 0; i < 3; ++i) {
                this.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        this.resetAllProcessing();
    }

    public boolean isHeated() {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(this.field_145850_b, this.field_174879_c);
        this.heated = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("growthcraft", "heatsources")).func_230235_a_((Object)blockMap.get("down"));
        return this.heated;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private MixingVatItemRecipe getItemRecipe(FluidStack fluidStack, List<ItemStack> ingredients) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.MIXING_VAT_ITEM_RECIPE_TYPE);
        for (MixingVatRecipe recipe : recipes) {
            MixingVatItemRecipe mixingVatRecipe = (MixingVatItemRecipe)recipe;
            if (!mixingVatRecipe.matches(fluidStack, ingredients)) continue;
            return mixingVatRecipe;
        }
        return null;
    }

    private MixingVatItemRecipe getRecipeByResult(ItemStack itemStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.MIXING_VAT_ITEM_RECIPE_TYPE);
        for (MixingVatRecipe recipe : recipes) {
            MixingVatItemRecipe mixingVatRecipe = (MixingVatItemRecipe)recipe;
            if (!mixingVatRecipe.matchResult(itemStack)) continue;
            return mixingVatRecipe;
        }
        return null;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private MixingVatFluidRecipe getFluidRecipe(FluidStack baseFluidStack, FluidStack reagentFluidStack, List<ItemStack> ingredients) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.MIXING_VAT_FLUID_RECIPE_TYPE);
        for (MixingVatRecipe recipe : recipes) {
            MixingVatFluidRecipe mixingVatRecipe = (MixingVatFluidRecipe)recipe;
            if (!mixingVatRecipe.matches(baseFluidStack, reagentFluidStack, ingredients)) continue;
            return mixingVatRecipe;
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_milk", "mixing_vat");
        return new TranslationTextComponent(translationKey);
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new MixingVatContainer(windowId, playerInventory, this);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory.toNonNullList();
    }

    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.inventory.setNonNullList(nonNullList);
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    public final GrowthcraftItemHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getInputFluidTank(int tankId) {
        return this.inputFluidTankHandler.getTank(tankId);
    }

    public FluidTank getOutputFluidTank(int tankId) {
        return this.outputFluidTankHandler.getTank(tankId);
    }

    public ItemStack getResultActivationTool() {
        return this.resultActivationTool;
    }

    private void resetAllProcessing() {
        this.currentRecipe = null;
        this.currentProcessingTime = 0;
        this.activated = false;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public int getProcessingTime() {
        return this.currentProcessingTime;
    }

    public void setProcessingTime(int time) {
        this.currentProcessingTime = time;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.activated = compound.func_74767_n("IsActivated");
        this.currentProcessingTime = compound.func_74762_e("CurrentProcessingTime");
        this.maxProcessingTime = compound.func_74762_e("MaxProcessingTime");
        this.inputFluidTankHandler.getTank(0).readFromNBT(compound.func_74775_l("tank0"));
        this.outputFluidTankHandler.getTank(0).readFromNBT(compound.func_74775_l("tank1"));
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74757_a("IsActivated", this.activated);
        compound.func_74768_a("CurrentProcessingTime", this.currentProcessingTime);
        compound.func_74768_a("MaxProcessingTime", this.maxProcessingTime);
        compound.func_218657_a("tank0", (INBT)this.inputFluidTankHandler.getTank(0).writeToNBT(new CompoundNBT()));
        compound.func_218657_a("tank1", (INBT)this.outputFluidTankHandler.getTank(0).writeToNBT(new CompoundNBT()));
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    private boolean tryPlaceItemInventory(ItemStack itemStack) {
        for (int i = 0; i < 3; ++i) {
            if (!this.getInventory().getStackInSlot(i).func_190926_b()) continue;
            this.getInventory().insertItem(i, itemStack, false);
            if (this.getInventory().getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void onEntityCollision(Entity entity) {
        if (!this.activated && entity instanceof ItemEntity && entity.func_233580_cy_().func_177958_n() == this.func_174877_v().func_177958_n() && entity.func_233580_cy_().func_177952_p() == this.func_174877_v().func_177952_p()) {
            ItemStack collisionItemStack = ((ItemEntity)entity).func_92059_d();
            if (collisionItemStack.func_190916_E() >= 1 && this.tryPlaceItemInventory(collisionItemStack.func_77946_l())) {
                ((ItemEntity)entity).func_92059_d().func_190918_g(1);
            }
            this.func_70296_d();
        }
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.UP) {
            return this.outputFluidTankHandler.getFluidTankHandler(0).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.NORTH) {
            return this.inputFluidTankHandler.getFluidTankHandler(0).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public ItemStack getActivationTool() {
        return this.activationTool;
    }

    public boolean activateRecipe(ItemStack itemStack) {
        if (this.activated) {
            return false;
        }
        this.activated = this.getActivationTool() != null && this.getActivationTool().func_77973_b() == itemStack.func_77973_b();
        return this.activated;
    }

    public boolean activateResult(PlayerEntity player, ItemStack resultActivationTool) {
        if (this.getResultActivationTool() != null && this.getResultActivationTool().func_77973_b() == resultActivationTool.func_77973_b()) {
            ItemStack itemStack = this.getInventory().extractItem(3, this.func_70301_a(3).func_190916_E(), false);
            if (!player.field_71071_by.func_70441_a(itemStack)) {
                player.func_71019_a(itemStack, false);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ItemStack getRecipeResultingItem() {
        return this.currentRecipe.getCategory() == MixingVatRecipe.MixingVatRecipeCategory.ITEM ? ((MixingVatItemRecipe)this.currentRecipe).getResultItemStack() : null;
    }

    public Boolean hasValidRecipe() {
        return this.currentRecipe != null;
    }
}

