/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture;

import com.github.elrol.industrialagriculture.config.MainConfig;
import com.github.elrol.industrialagriculture.init.IAContainerTypesRegistry;
import com.github.elrol.industrialagriculture.init.ItemInit;
import com.github.elrol.industrialagriculture.init.SoulInit;
import com.github.elrol.industrialagriculture.init.SoundInit;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="industrialagriculture")
public class IndustrialAgriculture {
    public static final Logger LOGGER = LogManager.getLogger();
    public static MainConfig config = MainConfig.load();

    public IndustrialAgriculture() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemInit.ITEMS.register(bus);
        IAContainerTypesRegistry.CONTAINER_TYPES.register(bus);
        bus.addListener(this::setup);
        ItemInit.registerItems(new ArrayList<Item>());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
        ItemInit.init(event);
    }

    @SubscribeEvent
    public static void onSoundsRegistry(RegistryEvent.Register<SoundEvent> event) {
        SoundInit.init(event);
    }

    static {
        SoulInit.preinit();
    }

    @Mod.EventBusSubscriber(modid="industrialagriculture", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

