/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.container;

import com.github.elrol.industrialagriculture.container.ItemStackHandlerSeedBag;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class IACapabilityProviderSeedBag
implements ICapabilitySerializable<INBT> {
    private final Direction NO_SPECIFIC_SIDE = null;
    private final int MAX_NUMBER_OF_SEEDS;
    private ItemStackHandlerSeedBag itemStackHandlerFlowerBag;
    private final LazyOptional<IItemHandler> lazyInitialisionSupplier = LazyOptional.of(this::getCachedInventory);
    private int tier;

    public IACapabilityProviderSeedBag(int tier, int max_seeds) {
        this.tier = tier;
        this.MAX_NUMBER_OF_SEEDS = max_seeds;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == cap) {
            return this.lazyInitialisionSupplier;
        }
        return LazyOptional.empty();
    }

    public INBT serializeNBT() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.getCachedInventory(), this.NO_SPECIFIC_SIDE);
    }

    public void deserializeNBT(INBT nbt) {
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.getCachedInventory(), this.NO_SPECIFIC_SIDE, nbt);
    }

    private ItemStackHandlerSeedBag getCachedInventory() {
        if (this.itemStackHandlerFlowerBag == null) {
            this.itemStackHandlerFlowerBag = new ItemStackHandlerSeedBag(this.tier, this.MAX_NUMBER_OF_SEEDS);
        }
        return this.itemStackHandlerFlowerBag;
    }
}

