/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.crusher;

import java.util.Collection;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.block.crusher.CrusherContainer;
import net.silentchaos512.mechanisms.crafting.recipe.CrushingRecipe;
import net.silentchaos512.mechanisms.init.MachineType;
import net.silentchaos512.mechanisms.init.ModRecipes;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class CrusherTileEntity
extends AbstractMachineTileEntity<CrushingRecipe> {
    private static final int MAX_ENERGY = 50000;
    private static final int MAX_RECEIVE = 500;
    private static final int ENERGY_USED_PER_TICK = 30;
    private static final int INPUT_SLOT_COUNT = 1;
    private static final int OUTPUT_SLOT_COUNT = 4;
    private static final int INVENTORY_SIZE = 5;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.range(1, 5).toArray();
    private static final int[] SLOTS_ALL = IntStream.range(0, 5).toArray();

    public CrusherTileEntity() {
        this(MachineTier.STANDARD);
    }

    public CrusherTileEntity(MachineTier tier) {
        super(MachineType.CRUSHER.getTileEntityType(tier), 5, tier);
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 30;
    }

    @Override
    protected int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    @Nullable
    protected CrushingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.Types.CRUSHING, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(CrushingRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<ItemStack> getProcessResults(CrushingRecipe recipe) {
        return recipe.getResults(this);
    }

    @Override
    protected Collection<ItemStack> getPossibleProcessResult(CrushingRecipe recipe) {
        return recipe.getPossibleResults(this);
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index < 1;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index >= 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "crusher", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new CrusherContainer(id, playerInventory, this, this.fields);
    }

    public static class Basic
    extends CrusherTileEntity {
        public Basic() {
            super(MachineTier.BASIC);
        }
    }
}

