/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.init.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModBlockTagsProvider
extends BlockTagsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ModBlockTagsProvider(DataGenerator gen) {
        super(gen);
    }

    protected void func_200432_c() {
        this.func_240522_a_(ModTags.Blocks.DRYING_RACKS).func_240534_a_((Object[])Registration.getBlocks(DryingRackBlock.class).toArray(new Block[0]));
        for (Metals metal : Metals.values()) {
            metal.getOreTag().ifPresent(tag -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Block[]{metal.getOre().get()}));
            metal.getStorageBlockTag().ifPresent(tag -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Block[]{metal.getStorageBlock().get()}));
        }
        this.groupBuilder((ITag.INamedTag<Block>)Tags.Blocks.ORES, Metals::getOreTag);
        this.groupBuilder((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS, Metals::getStorageBlockTag);
    }

    private void groupBuilder(ITag.INamedTag<Block> tag, Function<Metals, Optional<ITag.INamedTag<Block>>> tagGetter) {
        TagsProvider.Builder builder = this.func_240522_a_(tag);
        for (Metals metal : Metals.values()) {
            tagGetter.apply(metal).ifPresent(arg_0 -> ((TagsProvider.Builder)builder).func_240531_a_(arg_0));
        }
    }

    public String func_200397_b() {
        return "Silent's Mechanisms - Block Tags";
    }

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        this.field_200434_b.forEach((p_240524_4_, p_240524_5_) -> {
            JsonObject jsonobject = p_240524_5_.func_232965_c_();
            Path path = this.func_200431_a((ResourceLocation)p_240524_4_);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }
}

