/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.silentchaos512.mechanisms.data.ModBlockTagsProvider;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.item.CraftingItems;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModItemTagsProvider
extends ItemTagsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ModItemTagsProvider(DataGenerator generatorIn, ModBlockTagsProvider blockTags) {
        super(generatorIn, (BlockTagsProvider)blockTags);
    }

    protected void func_200432_c() {
        this.builder(ModItemTagsProvider.forgeId("nuggets/coal"), new IItemProvider[0]);
        this.builder(ModItemTagsProvider.forgeId("storage_blocks/charcoal"), new IItemProvider[0]);
        this.func_240522_a_(ModTags.Items.PLASTIC).func_240534_a_((Object[])new Item[]{CraftingItems.PLASTIC_SHEET.func_199767_j()});
        this.func_240522_a_(ModTags.Items.STEELS).func_240531_a_(Metals.ALUMINUM_STEEL.getIngotTag().get()).func_240531_a_(Metals.BISMUTH_STEEL.getIngotTag().get()).func_240531_a_(Metals.STEEL.getIngotTag().get());
        this.func_240522_a_(ModTags.Items.COAL_GENERATOR_FUELS).func_240531_a_(ItemTags.field_219775_L).func_240531_a_(ModItemTagsProvider.itemTag(ModItemTagsProvider.forgeId("nuggets/coal"))).func_240531_a_(ModItemTagsProvider.itemTag(ModItemTagsProvider.forgeId("storage_blocks/charcoal"))).func_240531_a_((ITag.INamedTag)Tags.Items.STORAGE_BLOCKS_COAL);
        this.func_240521_a_(ModTags.Blocks.DRYING_RACKS, ModTags.Items.DRYING_RACKS);
        this.func_240522_a_(ModTags.Items.DUSTS_COAL).func_240534_a_((Object[])new Item[]{CraftingItems.COAL_DUST.func_199767_j()});
        for (Metals metal : Metals.values()) {
            metal.getOreTag().ifPresent(tag -> this.func_240521_a_((ITag.INamedTag)tag, (ITag.INamedTag)metal.getOreItemTag().get()));
            metal.getStorageBlockTag().ifPresent(tag -> this.func_240521_a_((ITag.INamedTag)tag, (ITag.INamedTag)metal.getStorageBlockItemTag().get()));
            metal.getChunksTag().ifPresent(tag -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Item[]{metal.getChunks().get()}));
            metal.getDustTag().ifPresent(tag -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Item[]{metal.getDust().get()}));
            metal.getIngotTag().ifPresent(tag -> metal.getIngot().ifPresent(item -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Item[]{item})));
            metal.getNuggetTag().ifPresent(tag -> metal.getNugget().ifPresent(item -> this.func_240522_a_((ITag.INamedTag)tag).func_240534_a_((Object[])new Item[]{item})));
        }
        this.func_240521_a_((ITag.INamedTag)Tags.Blocks.ORES, (ITag.INamedTag)Tags.Items.ORES);
        this.func_240521_a_((ITag.INamedTag)Tags.Blocks.STORAGE_BLOCKS, (ITag.INamedTag)Tags.Items.STORAGE_BLOCKS);
        this.groupBuilder(ModTags.Items.CHUNKS, Metals::getChunksTag, new ITag.INamedTag[0]);
        this.groupBuilder((ITag.INamedTag<Item>)Tags.Items.DUSTS, Metals::getDustTag, ModTags.Items.DUSTS_COAL);
        this.groupBuilder((ITag.INamedTag<Item>)Tags.Items.INGOTS, Metals::getIngotTag, new ITag.INamedTag[0]);
        this.groupBuilder((ITag.INamedTag<Item>)Tags.Items.NUGGETS, Metals::getNuggetTag, new ITag.INamedTag[0]);
    }

    @SafeVarargs
    private final void groupBuilder(ITag.INamedTag<Item> tag, Function<Metals, Optional<ITag.INamedTag<Item>>> tagGetter, ITag.INamedTag<Item> ... extras) {
        TagsProvider.Builder builder = this.func_240522_a_(tag);
        for (Metals metals : Metals.values()) {
            tagGetter.apply(metals).ifPresent(arg_0 -> ((TagsProvider.Builder)builder).func_240531_a_(arg_0));
        }
        for (Metals metals : extras) {
            builder.func_240531_a_((ITag.INamedTag)metals);
        }
    }

    private void builder(ResourceLocation id, IItemProvider ... items) {
        this.func_240522_a_(ModItemTagsProvider.itemTag(id)).func_240534_a_((Object[])Arrays.stream(items).map(IItemProvider::func_199767_j).toArray(Item[]::new));
    }

    private static ITag.INamedTag<Item> itemTag(ResourceLocation id) {
        return ItemTags.func_199901_a((String)id.toString());
    }

    private static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    public String func_200397_b() {
        return "Silent's Mechanisms - Item Tags";
    }

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        this.field_200434_b.forEach((p_240524_4_, p_240524_5_) -> {
            JsonObject jsonobject = p_240524_5_.func_232965_c_();
            Path path = this.func_200431_a((ResourceLocation)p_240524_4_);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }
}

