/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.item;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.util.TextUtil;

public class CanisterItem
extends Item
implements IFluidContainer {
    public CanisterItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(@Nullable Fluid fluid) {
        return CanisterItem.getStack(fluid, 1);
    }

    public static ItemStack getStack(@Nullable Fluid fluid, int count) {
        ItemRegistryObject<CanisterItem> item = fluid != null ? ModItems.CANISTER : ModItems.EMPTY_CANISTER;
        ItemStack result = new ItemStack(item, count);
        if (fluid != null) {
            ResourceLocation fluidId = Objects.requireNonNull(fluid.getRegistryName());
            result.func_196082_o().func_74778_a("CanisterFluid", fluidId.toString());
        }
        return result;
    }

    public static String getFluidKey(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74779_i("CanisterFluid") : "";
    }

    @Override
    public FluidStack getFluid(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof CanisterItem)) {
            return FluidStack.EMPTY;
        }
        ResourceLocation fluidId = ResourceLocation.func_208304_a((String)CanisterItem.getFluidKey(stack));
        if (fluidId == null) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, 1000);
    }

    @Override
    public ItemStack fillWithFluid(ItemStack empty, FluidStack fluid) {
        return CanisterItem.getStack(fluid.getFluid());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        ITextComponent fluidText = fluid.isEmpty() ? TextUtil.translate("misc", "empty", new Object[0]) : fluid.getDisplayName();
        return new TranslationTextComponent(this.func_77658_a(), new Object[]{fluidText});
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack(ModItems.EMPTY_CANISTER);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)CanisterItem.getStack(null));
            ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.func_207193_c(f.func_207188_f())).map(CanisterItem::getStack).forEach(arg_0 -> items.add(arg_0));
        }
    }
}

