/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ChannelClientInfo;
import mcjty.xnet.client.ConnectedBlockClientInfo;
import mcjty.xnet.client.ConnectorClientInfo;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.controller.client.ChannelEditorPanel;
import mcjty.xnet.modules.controller.client.ConnectorEditorPanel;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.network.VanillaPacketSplitter;

public class GuiController
extends GenericGuiContainer<TileEntityController, GenericContainer> {
    public static final String TAG_ENABLED = "enabled";
    public static final String TAG_NAME = "name";
    private WidgetList connectorList;
    private List<SidedPos> connectorPositions = new ArrayList<SidedPos>();
    private int listDirty;
    private TextField searchBar;
    private int delayedSelectedChannel = -1;
    private int delayedSelectedLine = -1;
    private SidedPos delayedSelectedConnector = null;
    private Panel channelEditPanel;
    private Panel connectorEditPanel;
    private ToggleButton[] channelButtons = new ToggleButton[8];
    private SidedPos editingConnector = null;
    private int editingChannel = -1;
    private int showingChannel = -1;
    private SidedPos showingConnector = null;
    private static GuiController openController = null;
    private EnergyBar energyBar;
    private Button copyConnector = null;
    private boolean needsRefresh = true;

    public GuiController(TileEntityController controller, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)controller, (Container)container, inventory, ((BaseBlock)ControllerModule.CONTROLLER.get()).getManualEntry());
        openController = this;
    }

    public static void register() {
        GuiController.register((ContainerType)((ContainerType)ControllerModule.CONTAINER_CONTROLLER.get()), GuiController::new);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        openController = null;
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, XNetMessages.INSTANCE, new ResourceLocation("xnet", "gui/controller.gui"));
        super.func_231160_c_();
        this.initializeFields();
        this.setupEvents();
        this.editingConnector = null;
        this.editingChannel = -1;
        this.refresh();
        this.listDirty = 0;
    }

    private void setupEvents() {
        this.window.event("searchbar", (source, params) -> {
            this.needsRefresh = true;
        });
        int i = 0;
        while (i < 8) {
            String channel = "channel" + (i + 1);
            int finalI = i++;
            this.window.event(channel, (source, params) -> this.selectChannelEditor(finalI));
        }
    }

    private void initializeFields() {
        this.channelEditPanel = (Panel)this.window.findChild("channeleditpanel");
        this.connectorEditPanel = (Panel)this.window.findChild("connectoreditpanel");
        this.searchBar = (TextField)this.window.findChild("searchbar");
        this.connectorList = (WidgetList)this.window.findChild("connectors");
        this.connectorList.event((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(int index) {
                GuiController.this.hilightSelectedContainer(index);
            }
        });
        for (int i = 0; i < 8; ++i) {
            String name = "channel" + (i + 1);
            this.channelButtons[i] = (ToggleButton)this.window.findChild(name);
        }
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
    }

    private void updateFields() {
    }

    private void hilightSelectedContainer(int index) {
        if (index < 0) {
            return;
        }
        ConnectedBlockClientInfo c = ((TileEntityController)this.tileEntity).clientConnectedBlocks.get(index);
        if (c != null) {
            RFToolsBase.instance.clientInfo.hilightBlock(c.getPos().getPos(), System.currentTimeMillis() + 5000L);
            Logging.message((PlayerEntity)this.field_230706_i_.field_71439_g, (String)"The block is now highlighted");
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.handleClipboard(keyCode)) {
            return true;
        }
        if (this.handleKeyUpDown(keyCode)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        if (this.handleKeyUpDown(keyCode)) {
            return;
        }
        super.keyTypedFromEvent(keyCode, scanCode);
    }

    private boolean handleKeyUpDown(int keyCode) {
        if (this.getSelectedChannel() == -1) {
            return false;
        }
        if (keyCode == 265) {
            int sel = this.connectorList.getSelected();
            if (sel > 0) {
                this.connectorList.selected(--sel);
                this.selectConnectorEditor(this.connectorPositions.get(sel), this.getSelectedChannel());
            }
            return true;
        }
        if (keyCode == 264) {
            int sel = this.connectorList.getSelected();
            if (sel != -1 && sel < this.connectorList.getChildCount() - 1) {
                this.connectorList.selected(++sel);
                this.selectConnectorEditor(this.connectorPositions.get(sel), this.getSelectedChannel());
            }
            return true;
        }
        return false;
    }

    private boolean handleClipboard(int keyCode) {
        if (SafeClientTools.isCtrlKeyDown()) {
            if (keyCode == 67) {
                if (this.getSelectedChannel() != -1) {
                    this.copyConnector();
                } else {
                    GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing selected!");
                }
                return true;
            }
            if (keyCode == 86) {
                if (this.getSelectedChannel() != -1) {
                    this.pasteConnector();
                } else {
                    GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing selected!");
                }
                return true;
            }
        }
        return false;
    }

    private void selectChannelEditor(int finalI) {
        this.editingChannel = -1;
        this.showingConnector = null;
        for (int j = 0; j < 8; ++j) {
            if (j == finalI) continue;
            this.channelButtons[j].pressed(false);
            this.editingChannel = finalI;
        }
    }

    private void removeConnector(SidedPos sidedPos) {
        this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_REMOVECONNECTOR, TypedMap.builder().put(TileEntityController.PARAM_CHANNEL, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)sidedPos.getPos()).put(TileEntityController.PARAM_SIDE, (Object)sidedPos.getSide().ordinal()).build());
        this.refresh();
    }

    private void createConnector(SidedPos sidedPos) {
        this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_CREATECONNECTOR, TypedMap.builder().put(TileEntityController.PARAM_CHANNEL, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)sidedPos.getPos()).put(TileEntityController.PARAM_SIDE, (Object)sidedPos.getSide().ordinal()).build());
        this.refresh();
    }

    private void removeChannel() {
        GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Really remove channel " + (this.getSelectedChannel() + 1) + "?", () -> {
            this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_REMOVECHANNEL, TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).build());
            this.refresh();
        });
    }

    private void createChannel(String typeId) {
        this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_CREATECHANNEL, TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_TYPE, (Object)typeId).build());
        this.refresh();
    }

    public void refresh() {
        ((TileEntityController)this.tileEntity).clientChannels = null;
        ((TileEntityController)this.tileEntity).clientConnectedBlocks = null;
        this.showingChannel = -1;
        this.showingConnector = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private void selectConnectorEditor(SidedPos sidedPos, int finalI) {
        this.editingConnector = sidedPos;
        this.selectChannelEditor(finalI);
    }

    private void refreshChannelEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingChannel != -1 && this.showingChannel != this.editingChannel) {
            this.showingChannel = this.editingChannel;
            this.channelButtons[this.editingChannel].pressed(true);
            this.copyConnector = null;
            this.channelEditPanel.removeChildren();
            if (this.channelButtons[this.editingChannel].isPressed()) {
                ChannelClientInfo info = ((TileEntityController)this.tileEntity).clientChannels.get(this.editingChannel);
                if (info != null) {
                    ChannelEditorPanel editor = new ChannelEditorPanel(this.channelEditPanel, this.field_230706_i_, this, this.editingChannel);
                    editor.label("Channel " + (this.editingChannel + 1)).shift(5).toggle(TAG_ENABLED, "Enable processing on this channel", info.isEnabled()).shift(5).text(TAG_NAME, "Channel name", info.getChannelName(), 65);
                    info.getChannelSettings().createGui((IEditorGui)editor);
                    Button remove = ((Button)((Button)Widgets.button((int)151, (int)1, (int)9, (int)10, (String)"x").textOffset(0, -1)).tooltips(new String[]{"Remove this channel"})).event(this::removeChannel);
                    this.channelEditPanel.children(new Widget[]{remove});
                    editor.setState(info.getChannelSettings());
                    Button copyChannel = ((Button)Widgets.button((int)134, (int)19, (int)25, (int)14, (String)"C").tooltips(new String[]{"Copy this channel to", "the clipboard"})).event(this::copyChannel);
                    this.channelEditPanel.children(new Widget[]{copyChannel});
                    this.copyConnector = ((Button)Widgets.button((int)114, (int)19, (int)25, (int)14, (String)"C").tooltips(new String[]{"Copy this connector", "to the clipboard"})).event(this::copyConnector);
                    this.channelEditPanel.children(new Widget[]{this.copyConnector});
                } else {
                    ChoiceLabel type = (ChoiceLabel)new ChoiceLabel().hint(5, 3, 95, 14);
                    for (IChannelType channelType : XNet.xNetApi.getChannels().values()) {
                        type.choices(new String[]{channelType.getID()});
                    }
                    Button create = Widgets.button((int)100, (int)3, (int)53, (int)14, (String)"Create").event(() -> this.createChannel(type.getCurrentChoice()));
                    Button paste = ((Button)Widgets.button((int)100, (int)17, (int)53, (int)14, (String)"Paste").tooltips(new String[]{"Create a new channel", "from the clipboard"})).event(this::pasteChannel);
                    this.channelEditPanel.children(new Widget[]{type, create, paste});
                }
            }
        } else if (this.showingChannel != -1 && this.editingChannel == -1) {
            this.showingChannel = -1;
            this.channelEditPanel.removeChildren();
        }
    }

    public static void showMessage(Minecraft mc, Screen gui, WindowManager windowManager, int x, int y, String title) {
        GuiController.showMessage(mc, gui, windowManager, x, y, title, null);
    }

    public static void showMessage(Minecraft mc, Screen gui, WindowManager windowManager, int x, int y, String title, ButtonEvent okEvent) {
        Panel ask = (Panel)((Panel)Widgets.vertical().filledBackground(-10066330, -5592406)).filledRectThickness(1);
        ask.bounds(x, y, 200, 40);
        Window askWindow = windowManager.createModalWindow((AbstractContainerWidget)ask);
        ask.children(new Widget[]{Widgets.label((String)title)});
        Panel buttons = (Panel)((Panel)Widgets.horizontal().desiredWidth(100)).desiredHeight(18);
        if (okEvent != null) {
            buttons.children(new Widget[]{Widgets.button((String)"Cancel").event(() -> windowManager.closeWindow(askWindow))});
            buttons.children(new Widget[]{Widgets.button((String)"OK").event(() -> {
                windowManager.closeWindow(askWindow);
                okEvent.buttonClicked();
            })});
        } else {
            buttons.children(new Widget[]{Widgets.button((String)"OK").event(() -> windowManager.closeWindow(askWindow))});
        }
        ask.children(new Widget[]{buttons});
    }

    private void copyConnector() {
        if (this.editingConnector != null) {
            this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_COPYCONNECTOR, TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)this.editingConnector.getPos()).put(TileEntityController.PARAM_SIDE, (Object)this.editingConnector.getSide().ordinal()).build());
        }
    }

    private void copyChannel() {
        GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.GREEN + "Copied channel");
        this.sendServerCommandTyped(XNetMessages.INSTANCE, TileEntityController.CMD_COPYCHANNEL, TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).build());
    }

    public static void showError(String error) {
        if (openController != null) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiController.showMessage(mc, (Screen)openController, openController.getWindowManager(), 50, 50, TextFormatting.RED + error);
        }
    }

    public static void toClipboard(String json) {
        try {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(json);
        }
        catch (Exception e) {
            GuiController.showError("Error copying to clipboard!");
        }
    }

    private void pasteConnector() {
        try {
            String json = Minecraft.func_71410_x().field_195559_v.func_197965_a();
            int max = (Integer)Config.controllerMaxPaste.get();
            if (max >= 0 && json.length() > max) {
                GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard too large!");
                return;
            }
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            String type = root.get("type").getAsString();
            IChannelType channelType = XNet.xNetApi.findType(type);
            if (channelType == null) {
                GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Unsupported channel type: " + type + "!");
                return;
            }
            PacketServerCommandTyped packet = new PacketServerCommandTyped(((TileEntityController)this.tileEntity).func_174877_v(), ((TileEntityController)this.tileEntity).getDimension(), TileEntityController.CMD_PASTECONNECTOR.getName(), TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_POS, (Object)this.editingConnector.getPos()).put(TileEntityController.PARAM_SIDE, (Object)this.editingConnector.getSide().ordinal()).put(TileEntityController.PARAM_JSON, (Object)json).build());
            this.sendSplit(packet, max < 0);
            if (this.connectorList.getSelected() != -1) {
                this.delayedSelectedChannel = this.getSelectedChannel();
                this.delayedSelectedLine = this.connectorList.getSelected();
                this.delayedSelectedConnector = this.connectorPositions.get(this.connectorList.getSelected());
            }
            this.refresh();
        }
        catch (Exception e) {
            GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error reading from clipboard!");
        }
    }

    private void pasteChannel() {
        try {
            String json = Minecraft.func_71410_x().field_195559_v.func_197965_a();
            int max = (Integer)Config.controllerMaxPaste.get();
            if (max >= 0 && json.length() > max) {
                GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard too large!");
                return;
            }
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            String type = root.get("type").getAsString();
            IChannelType channelType = XNet.xNetApi.findType(type);
            if (channelType == null) {
                GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Unsupported channel type: " + type + "!");
                return;
            }
            PacketServerCommandTyped packet = new PacketServerCommandTyped(((TileEntityController)this.tileEntity).func_174877_v(), ((TileEntityController)this.tileEntity).getDimension(), TileEntityController.CMD_PASTECHANNEL.getName(), TypedMap.builder().put(TileEntityController.PARAM_INDEX, (Object)this.getSelectedChannel()).put(TileEntityController.PARAM_JSON, (Object)json).build());
            this.sendSplit(packet, max < 0);
            this.refresh();
        }
        catch (Exception e) {
            GuiController.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error reading from clipboard!");
        }
    }

    private void sendSplit(PacketServerCommandTyped packet, boolean doSplit) {
        if (doSplit) {
            IPacket vanillaPacket = XNetMessages.INSTANCE.toVanillaPacket((Object)packet, NetworkDirection.PLAY_TO_SERVER);
            ArrayList packets = new ArrayList();
            VanillaPacketSplitter.appendPackets((ProtocolType)ProtocolType.PLAY, (PacketDirection)PacketDirection.SERVERBOUND, (IPacket)vanillaPacket, packets);
            NetworkManager connection = Minecraft.func_71410_x().func_147114_u().func_147298_b();
            packets.forEach(arg_0 -> ((NetworkManager)connection).func_179290_a(arg_0));
        } else {
            XNetMessages.INSTANCE.sendToServer((Object)packet);
        }
    }

    private ConnectorClientInfo findClientInfo(ChannelClientInfo info, SidedPos p) {
        for (ConnectorClientInfo connector : info.getConnectors().values()) {
            if (!connector.getPos().equals((Object)p)) continue;
            return connector;
        }
        return null;
    }

    private void refreshConnectorEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingConnector != null && !this.editingConnector.equals((Object)this.showingConnector)) {
            this.showingConnector = this.editingConnector;
            this.connectorEditPanel.removeChildren();
            ChannelClientInfo info = ((TileEntityController)this.tileEntity).clientChannels.get(this.editingChannel);
            if (info != null) {
                ConnectorClientInfo clientInfo = this.findClientInfo(info, this.editingConnector);
                if (clientInfo != null) {
                    Direction side = clientInfo.getPos().getSide();
                    SidedConsumer sidedConsumer = new SidedConsumer(clientInfo.getConsumerId(), side.func_176734_d());
                    ConnectorClientInfo connectorInfo = info.getConnectors().get(sidedConsumer);
                    Button remove = ((Button)((Button)Widgets.button((int)151, (int)1, (int)9, (int)10, (String)"x").textOffset(0, -1)).tooltips(new String[]{"Remove this connector"})).event(() -> this.removeConnector(this.editingConnector));
                    ConnectorEditorPanel editor = new ConnectorEditorPanel(this.connectorEditPanel, this.field_230706_i_, this, this.editingChannel, this.editingConnector);
                    connectorInfo.getConnectorSettings().createGui((IEditorGui)editor);
                    this.connectorEditPanel.children(new Widget[]{remove});
                    editor.setState(connectorInfo.getConnectorSettings());
                } else {
                    Button create = Widgets.button((int)85, (int)20, (int)60, (int)14, (String)"Create").event(() -> this.createConnector(this.editingConnector));
                    this.connectorEditPanel.children(new Widget[]{create});
                    Button paste = ((Button)Widgets.button((int)85, (int)40, (int)60, (int)14, (String)"Paste").tooltips(new String[]{"Create a new connector", "from the clipboard"})).event(this::pasteConnector);
                    this.connectorEditPanel.children(new Widget[]{paste});
                }
            }
        } else if (this.showingConnector != null && this.editingConnector == null) {
            this.showingConnector = null;
            this.connectorEditPanel.removeChildren();
        }
    }

    private void requestListsIfNeeded() {
        if (((TileEntityController)this.tileEntity).clientChannels != null && ((TileEntityController)this.tileEntity).clientConnectedBlocks != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((TileEntityController)this.tileEntity).func_174877_v(), TileEntityController.CMD_GETCHANNELS.getName()));
            XNetMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((TileEntityController)this.tileEntity).func_174877_v(), TileEntityController.CMD_GETCONNECTEDBLOCKS.getName()));
            this.listDirty = 10;
            this.showingChannel = -1;
            this.showingConnector = null;
        }
    }

    private int getSelectedChannel() {
        for (int i = 0; i < 8; ++i) {
            if (!this.channelButtons[i].isPressed()) continue;
            return i;
        }
        return -1;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.connectorList.removeChildren();
        this.connectorPositions.clear();
        int sel = this.connectorList.getSelected();
        BlockPos prevPos = null;
        String selectedText = this.searchBar.getText().trim().toLowerCase();
        for (ConnectedBlockClientInfo connectedBlock : ((TileEntityController)this.tileEntity).clientConnectedBlocks) {
            BlockRender br;
            SidedPos sidedPos = connectedBlock.getPos();
            BlockPos coordinate = sidedPos.getPos();
            String name = connectedBlock.getName();
            String blockUnlocName = connectedBlock.getBlockUnlocName();
            String blockName = I18n.func_135052_a((String)blockUnlocName, (Object[])new Object[0]).trim();
            int color = StyleConfig.colorTextInListNormal;
            Panel panel = Widgets.horizontal((int)0, (int)0);
            if (!selectedText.isEmpty() && blockName.toLowerCase().contains(selectedText)) {
                panel.filledBackground(-2232662);
            }
            if (coordinate.equals(prevPos)) {
                br = new BlockRender();
            } else {
                br = new BlockRender().renderItem((Object)connectedBlock.getConnectedBlock());
                prevPos = coordinate;
            }
            br.userObject((Object)"block");
            panel.children(new Widget[]{br});
            if (!name.isEmpty()) {
                br.tooltips(new String[]{TextFormatting.GREEN + "Connector: " + TextFormatting.WHITE + name, TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            } else {
                br.tooltips(new String[]{TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            }
            panel.children(new Widget[]{((Label)Widgets.label((String)sidedPos.getSide().func_176610_l().substring(0, 1).toUpperCase()).color(color)).desiredWidth(18)});
            int i = 0;
            while (i < 8) {
                ConnectorClientInfo clientInfo;
                Button but = (Button)new Button().desiredWidth(14);
                ChannelClientInfo info = ((TileEntityController)this.tileEntity).clientChannels.get(i);
                if (info != null && (clientInfo = this.findClientInfo(info, sidedPos)) != null) {
                    String indicator;
                    IndicatorIcon icon = clientInfo.getConnectorSettings().getIndicatorIcon();
                    if (icon != null) {
                        but.image(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    but.text((indicator = clientInfo.getConnectorSettings().getIndicator()) != null ? indicator : "");
                }
                int finalI = i++;
                but.event(() -> this.selectConnectorEditor(sidedPos, finalI));
                panel.children(new Widget[]{but});
            }
            this.connectorList.children(new Widget[]{panel});
            this.connectorPositions.add(sidedPos);
        }
        this.connectorList.selected(sel);
        if (this.delayedSelectedChannel != -1) {
            this.connectorList.selected(this.delayedSelectedLine);
            this.selectConnectorEditor(this.delayedSelectedConnector, this.delayedSelectedChannel);
        }
        this.delayedSelectedChannel = -1;
        this.delayedSelectedLine = -1;
        this.delayedSelectedConnector = null;
    }

    private boolean listsReady() {
        return ((TileEntityController)this.tileEntity).clientChannels != null && ((TileEntityController)this.tileEntity).clientConnectedBlocks != null;
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float v, int x1, int x2) {
        this.updateFields();
        this.requestListsIfNeeded();
        this.populateList();
        this.refreshChannelEditor();
        this.refreshConnectorEditor();
        if (this.listsReady() && this.copyConnector != null && this.editingChannel != -1) {
            ChannelClientInfo info = ((TileEntityController)this.tileEntity).clientChannels.get(this.editingChannel);
            ConnectorClientInfo clientInfo = this.findClientInfo(info, this.editingConnector);
            this.copyConnector.enabled(clientInfo != null);
        }
        if (((TileEntityController)this.tileEntity).clientChannels != null) {
            for (int i = 0; i < 8; ++i) {
                String channel = String.valueOf(i + 1);
                ChannelClientInfo info = ((TileEntityController)this.tileEntity).clientChannels.get(i);
                if (info != null) {
                    String indicator;
                    IndicatorIcon icon = info.getChannelSettings().getIndicatorIcon();
                    if (icon != null) {
                        this.channelButtons[i].image(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    if ((indicator = info.getChannelSettings().getIndicator()) != null) {
                        this.channelButtons[i].text(indicator + channel);
                        continue;
                    }
                    this.channelButtons[i].text(channel);
                    continue;
                }
                this.channelButtons[i].image(null, 0, 0, 0, 0);
                this.channelButtons[i].text(channel);
            }
        }
        this.drawWindow(matrixStack);
        int channel = this.getSelectedChannel();
        if (channel != -1) {
            int x = (int)this.window.getToplevel().getBounds().getX();
            int y = (int)this.window.getToplevel().getBounds().getY();
            RenderHelper.drawVerticalGradientRect((int)(x + channel * 14 + 41), (int)(y + 22), (int)(x + channel * 14 + 41 + 12), (int)(y + 230), (int)0x33AAFFFF, (int)0x33AAFFFF);
        }
        ((TileEntityController)this.tileEntity).getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> {
            long currentRF = h.getEnergyStored();
            int max = h.getMaxEnergyStored();
            this.energyBar.value(currentRF).maxValue((long)max);
        });
    }

    protected void drawStackTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        Widget widget = this.window.getToplevel().getWidgetAtPosition((double)x, (double)y);
        if (widget instanceof BlockRender && "block".equals(widget.getUserObject())) {
            return;
        }
        super.drawStackTooltips(matrixStack, mouseX, mouseY);
    }
}

