/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import me.shedaniel.architectury.hooks.PlayerHooks;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.storage.FolderName;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final FolderName DATA_DIR = LevelResourceHooks.create((String)"ftbchunks");
    public final TeamManager teamManager;
    public final Map<UUID, FTBChunksTeamData> teamData;
    public final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    public Path dataDirectory;
    public Path localDirectory;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().func_240776_a_(DATA_DIR);
        this.localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(this.localDirectory, new LinkOption[0])) {
                Files.createDirectories(this.localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init() {
        long nanos = System.nanoTime();
        int forceLoaded = 0;
        for (ClaimedChunk chunk : this.claimedChunks.values()) {
            if (!chunk.isForceLoaded() || !chunk.getTeamData().getChunkLoadOffline()) continue;
            ++forceLoaded;
            chunk.postSetForceLoaded(true);
        }
        FTBChunks.LOGGER.info("Server " + this.teamManager.getId() + ": Loaded " + this.claimedChunks.size() + " chunks (" + forceLoaded + " force loaded) from " + this.teamData.size() + " teams in " + (double)(System.nanoTime() - nanos) / 1000000.0 + "ms");
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((CompoundNBT)dataFile);
            this.teamData.put(team.getId(), data);
            for (ClaimedChunk chunk : data.getClaimedChunks()) {
                if (!chunk.isForceLoaded() || !chunk.getTeamData().getChunkLoadOffline()) continue;
                chunk.postSetForceLoaded(true);
            }
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getData(ServerPlayerEntity player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((ServerPlayerEntity)player));
    }

    public boolean hasData(ServerPlayerEntity player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player.func_110124_au());
        return team != null && this.teamData.containsKey(team.getId());
    }

    public void deleteTeam(Team toDelete) {
        FTBChunksTeamData data = this.teamData.get(toDelete.getId());
        if (data != null && toDelete.getMembers().isEmpty()) {
            FTBChunks.LOGGER.debug("dropping references to empty team " + toDelete.getId());
            this.teamData.remove(toDelete.getId());
            try {
                Files.deleteIfExists(data.file);
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error(String.format("can't delete file %s: %s", data.file, e.getMessage()));
            }
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public boolean getBypassProtection(UUID player) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        return team != null && team.getExtraData().func_74767_n("BypassFTBChunksProtection");
    }

    public void setBypassProtection(UUID player, boolean bypass) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        if (team != null) {
            team.getExtraData().func_74757_a("BypassFTBChunksProtection", bypass);
            team.save();
        }
    }

    public boolean protect(@Nullable Entity entity, Hand hand, BlockPos pos, Protection protection) {
        if (!(entity instanceof ServerPlayerEntity) || ((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue()) {
            return false;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        boolean isFake = PlayerHooks.isFake((PlayerEntity)player);
        if (isFake && ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).getProtect();
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(player.field_70170_p, pos));
        if (chunk != null) {
            ProtectionOverride override = protection.override(player, pos, hand, chunk);
            if (override.isOverride()) {
                return override.getProtect();
            }
            return isFake || !this.getBypassProtection(player.func_110124_au());
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionOverride override = protection.override(player, pos, hand, null);
            if (override.isOverride()) {
                return override.getProtect();
            }
            if (!isFake && this.getBypassProtection(player.func_110124_au())) {
                return false;
            }
            player.func_146105_b((ITextComponent)new StringTextComponent("You need to claim this chunk to interact with blocks here!"), true);
            return true;
        }
        return false;
    }
}

