/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.pedestal;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gems.block.pedestal.PedestalTileEntity;
import net.silentchaos512.lib.util.PlayerUtils;

public class PedestalBlock
extends Block
implements IWaterLoggable {
    private static final VoxelShape SHAPE_PILLAR = Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    private static final VoxelShape SHAPE_BOTTOM1 = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape SHAPE_BOTTOM2 = Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    private static final VoxelShape SHAPE_TOP1 = Block.func_208617_a((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP2 = Block.func_208617_a((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape SHAPE = PedestalBlock.createShape(SHAPE_PILLAR, SHAPE_BOTTOM1, SHAPE_BOTTOM2, SHAPE_TOP1, SHAPE_TOP2);

    private static VoxelShape createShape(VoxelShape ... shapes) {
        VoxelShape shape = shapes[0];
        for (int i = 1; i < shapes.length; ++i) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)shapes[i]);
        }
        return shape;
    }

    public PedestalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PedestalTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tile));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            ItemStack stack = pedestal.func_70301_a(0);
            if (!stack.func_190926_b()) {
                PlayerUtils.giveItem((PlayerEntity)player, (ItemStack)stack);
                pedestal.setItem(ItemStack.field_190927_a);
            } else {
                ItemStack inHand = player.func_184614_ca();
                if (!inHand.func_190926_b()) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, inHand);
                    pedestal.setItem(inHand);
                    inHand.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

