/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.World;
import net.silentchaos512.gems.block.pedestal.PedestalTileEntity;
import net.silentchaos512.lib.event.ClientTicks;

public class PedestalRenderer
extends TileEntityRenderer<PedestalTileEntity> {
    public PedestalRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PedestalTileEntity te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.func_145831_w() == null || !te.func_145831_w().isAreaLoaded(te.func_174877_v(), 1)) {
            return;
        }
        ItemStack stack = te.getItem();
        if (stack.func_190926_b()) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        float worldTime = (float)ClientTicks.ticksInGame() + partialTicks + (float)(te.func_174877_v().hashCode() % 360);
        PedestalRenderer.renderItem(te.func_145831_w(), stack, matrixStackIn, bufferIn, combinedLightIn, partialTicks, worldTime);
    }

    private static void renderItem(World world, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float partialTicks, float worldTime) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (stack != null) {
            ItemStack itemStack = stack.func_77946_l();
            itemStack.func_190920_e(1);
            matrixStack.func_227860_a_();
            RenderSystem.disableLighting();
            matrixStack.func_227861_a_(0.5, 1.35 + (double)0.05f * Math.sin(worldTime / 15.0f), 0.5);
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) + worldTime * 2.0f;
            matrixStack.func_227863_a_(new Quaternion(0.0f, rotation, 0.0f, true));
            float scale = 0.5f;
            matrixStack.func_227862_a_(scale, scale, scale);
            RenderSystem.pushLightingAttributes();
            RenderHelper.func_227780_a_();
            itemRenderer.func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, combinedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
            RenderHelper.func_74518_a();
            RenderSystem.popAttributes();
            RenderSystem.enableLighting();
            matrixStack.func_227865_b_();
        }
    }
}

