/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gems.block.supercharger.SuperchargerPillarStructure;
import net.silentchaos512.gems.compat.jei.SilentGemsPlugin;
import net.silentchaos512.gems.init.GemsBlocks;

public class SuperchargerPillarCategory
implements IRecipeCategory<SuperchargerPillarStructure> {
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 87;
    private static final int GUI_WIDTH = 120;
    private static final int GUI_HEIGHT = 30;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public SuperchargerPillarCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SilentGemsPlugin.GUI_TEXTURE, 0, 87, 120, 30);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(GemsBlocks.SUPERCHARGER));
        this.localizedName = I18n.func_135052_a((String)"category.silentgems.supercharger_pillar", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SilentGemsPlugin.SUPERCHARGER_PILLAR;
    }

    public Class<? extends SuperchargerPillarStructure> getRecipeClass() {
        return SuperchargerPillarStructure.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SuperchargerPillarStructure recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>(recipe.getBlocks());
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack(GemsBlocks.SUPERCHARGER));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SuperchargerPillarStructure recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        for (int i = 0; i < 5; ++i) {
            itemStacks.init(i, true, 1 + 16 * i, 1);
        }
        ArrayList inputs = new ArrayList();
        recipe.getBlocks().forEach(ingredient -> {
            List<ItemStack> list = Arrays.asList(ingredient.func_193365_a());
            inputs.add(list);
        });
        for (int i = 0; i < inputs.size(); ++i) {
            itemStacks.set(i, (List)inputs.get(i));
        }
    }

    public void draw(SuperchargerPillarStructure recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        int tier = recipe.getTier();
        String str = I18n.func_135052_a((String)"block.silentgems.supercharger.tier", (Object[])new Object[]{String.valueOf(tier)});
        FontRenderer fontRenderer = mc.field_71466_p;
        mc.field_71466_p.getClass();
        fontRenderer.func_238405_a_(matrixStack, str, 2.0f, (float)(30 - 9 - 1), -1);
    }
}

