/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsRecipeInit;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.util.InventoryUtils;
import net.silentchaos512.lib.collection.StackList;

public class TokenEnchanterRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<TokenEnchanterRecipe> RECIPE_TYPE = new IRecipeType<TokenEnchanterRecipe>(){

        public String toString() {
            return "silentgems:token_enchanting";
        }
    };
    private final ResourceLocation id;
    private int chaosGenerated;
    private int processTime;
    private ItemStack result;
    private Ingredient token;
    private final Map<Ingredient, Integer> ingredientMap = new LinkedHashMap<Ingredient, Integer>();
    private boolean valid = true;

    public TokenEnchanterRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Ingredient getToken() {
        return this.token;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return Collections.unmodifiableMap(this.ingredientMap);
    }

    public void consumeIngredients(IInventory inv) {
        InventoryUtils.consumeItems(inv, (Predicate<ItemStack>)this.token, 1);
        this.ingredientMap.forEach((ingredient, count) -> InventoryUtils.consumeItems(inv, (Predicate<ItemStack>)ingredient, count));
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (!this.valid) {
            return false;
        }
        StackList list = StackList.from((IInventory)inv);
        if (list.firstMatch(s -> this.token.test(s)).func_190926_b()) {
            return false;
        }
        for (Map.Entry<Ingredient, Integer> entry : this.ingredientMap.entrySet()) {
            Ingredient ingredient = entry.getKey();
            int count = entry.getValue();
            int countInInv = 0;
            for (ItemStack stack : list) {
                if (!ingredient.test(stack)) continue;
                countInInv += stack.func_190916_E();
            }
            if (countInInv >= count) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)GemsRecipeInit.TOKEN_ENCHANTING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TokenEnchanterRecipe> {
        public TokenEnchanterRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonElement elem2;
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.chaosGenerated = JSONUtils.func_151208_a((JsonObject)json, (String)"chaosGenerated", (int)200);
            recipe.processTime = JSONUtils.func_151208_a((JsonObject)json, (String)"processTime", (int)50);
            JsonObject ingredientsJson = json.get("ingredients").getAsJsonObject();
            recipe.token = Ingredient.func_199802_a((JsonElement)ingredientsJson.get("token").getAsJsonObject());
            JsonArray othersArray = ingredientsJson.get("others").getAsJsonArray();
            for (JsonElement elem2 : othersArray) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)elem2);
                int count = JSONUtils.func_151208_a((JsonObject)elem2.getAsJsonObject(), (String)"count", (int)1);
                recipe.ingredientMap.put(ingredient, count);
            }
            JsonObject resultJson = json.get("result").getAsJsonObject();
            recipe.result = Serializer.deserializeItem(resultJson);
            elem2 = resultJson.get("enchantments");
            if (elem2 != null) {
                for (JsonElement elem1 : elem2.getAsJsonArray()) {
                    JsonObject elemObj = elem1.getAsJsonObject();
                    String name = JSONUtils.func_151200_h((JsonObject)elemObj, (String)"name");
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
                    if (enchantment == null) {
                        recipe.valid = false;
                        continue;
                    }
                    int level = JSONUtils.func_151208_a((JsonObject)elemObj, (String)"level", (int)1);
                    Serializer.addEnchantment(recipe.result, enchantment, level);
                }
            }
            if (recipe.result.func_77973_b() instanceof ChaosRuneItem) {
                JsonElement elem1 = resultJson.get("buff");
                if (elem1 != null) {
                    ResourceLocation buffId = new ResourceLocation(elem1.getAsString());
                    recipe.result = ChaosRuneItem.getStack(buffId);
                } else {
                    throw new JsonSyntaxException("Chaos rune recipe is missing 'buff' string");
                }
            }
            if (!recipe.valid) {
                Serializer.logInvalidRecipe(recipe);
            }
            return recipe;
        }

        public TokenEnchanterRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.result = buffer.func_150791_c();
            recipe.token = Ingredient.func_199566_b((PacketBuffer)buffer);
            int otherCount = buffer.func_150792_a();
            for (int i = 0; i < otherCount; ++i) {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                int count = buffer.func_150792_a();
                recipe.ingredientMap.put(ingredient, count);
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, TokenEnchanterRecipe recipe) {
            buffer.func_150788_a(recipe.result);
            recipe.token.func_199564_a(buffer);
            buffer.func_150787_b(recipe.ingredientMap.size());
            recipe.ingredientMap.forEach((ingredient, count) -> {
                ingredient.func_199564_a(buffer);
                buffer.func_150787_b(count.intValue());
            });
        }

        private static ItemStack deserializeItem(JsonObject json) {
            return ShapedRecipe.func_199798_a((JsonObject)json);
        }

        private static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
            if (stack.func_77973_b() instanceof EnchantmentTokenItem) {
                EnchantmentTokenItem.addEnchantment(stack, enchantment, level);
            } else {
                stack.func_77966_a(enchantment, level);
            }
        }

        private static void logInvalidRecipe(TokenEnchanterRecipe recipe) {
            String msg = "Token enchanter recipe '{}' is invalid, enchantment does not exist";
            if ("silentgems".equals(recipe.func_199560_c().func_110624_b())) {
                SilentGems.LOGGER.debug(msg, (Object)recipe.func_199560_c());
            } else {
                SilentGems.LOGGER.warn(msg, (Object)recipe.func_199560_c());
            }
        }
    }
}

