/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyBlock;
import net.silentchaos512.gems.block.FluffyPuffPlant;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.block.MultiGemOreBlock;
import net.silentchaos512.gems.block.WildFluffyPuffPlant;
import net.silentchaos512.gems.block.altar.AltarBlock;
import net.silentchaos512.gems.block.flowerpot.LuminousFlowerPotBlock;
import net.silentchaos512.gems.block.flowerpot.PhantomLightBlock;
import net.silentchaos512.gems.block.pedestal.PedestalBlock;
import net.silentchaos512.gems.block.purifier.PurifierBlock;
import net.silentchaos512.gems.block.supercharger.SuperchargerBlock;
import net.silentchaos512.gems.block.teleporter.TeleporterBaseBlock;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterBlock;
import net.silentchaos512.gems.block.urn.SoulUrnBlock;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public final class GemsBlocks {
    public static final BlockRegistryObject<TeleporterBaseBlock> TELEPORTER_ANCHOR;
    public static final BlockRegistryObject<MultiGemOreBlock> MULTI_ORE_CLASSIC;
    public static final BlockRegistryObject<MultiGemOreBlock> MULTI_ORE_DARK;
    public static final BlockRegistryObject<MultiGemOreBlock> MULTI_ORE_LIGHT;
    public static final BlockRegistryObject<FluffyBlock> WHITE_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> ORANGE_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> MAGENTA_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> LIGHT_BLUE_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> YELLOW_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> LIME_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> PINK_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> GRAY_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> LIGHT_GRAY_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> CYAN_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> PURPLE_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> BLUE_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> BROWN_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> GREEN_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> RED_FLUFFY_BLOCK;
    public static final BlockRegistryObject<FluffyBlock> BLACK_FLUFFY_BLOCK;
    public static final BlockRegistryObject<SoulUrnBlock> SOUL_URN;
    public static final BlockRegistryObject<SuperchargerBlock> SUPERCHARGER;
    public static final BlockRegistryObject<TokenEnchanterBlock> TOKEN_ENCHANTER;
    public static final BlockRegistryObject<AltarBlock> TRANSMUTATION_ALTAR;
    public static final BlockRegistryObject<PurifierBlock> PURIFIER;
    public static final BlockRegistryObject<PedestalBlock> STONE_PEDESTAL;
    public static final BlockRegistryObject<PedestalBlock> GRANITE_PEDESTAL;
    public static final BlockRegistryObject<PedestalBlock> DIORITE_PEDESTAL;
    public static final BlockRegistryObject<PedestalBlock> ANDESITE_PEDESTAL;
    public static final BlockRegistryObject<PedestalBlock> OBSIDIAN_PEDESTAL;
    public static final BlockRegistryObject<LuminousFlowerPotBlock> LUMINOUS_FLOWER_POT;
    public static final BlockRegistryObject<PhantomLightBlock> PHANTOM_LIGHT;
    public static final BlockRegistryObject<FluffyPuffPlant> FLUFFY_PUFF_PLANT;
    public static final BlockRegistryObject<WildFluffyPuffPlant> WILD_FLUFFY_PUFF_PLANT;

    private GemsBlocks() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        for (Gems gem : Gems.values()) {
            RenderTypeLookup.setRenderLayer((Block)gem.getGlass(), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)gem.getGlowrose(), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)gem.getPottedGlowrose(), (RenderType)RenderType.func_228643_e_());
        }
        RenderTypeLookup.setRenderLayer((Block)((Block)FLUFFY_PUFF_PLANT.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WILD_FLUFFY_PUFF_PLANT.get()), (RenderType)RenderType.func_228643_e_());
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return GemsBlocks.register(name, block, GemsBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = GemsBlocks.registerNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static BlockRegistryObject<FluffyBlock> registerFluffyBlock(DyeColor color) {
        return GemsBlocks.register(color.func_176762_d() + "_fluffy_block", () -> new FluffyBlock(color));
    }

    public static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(GemsItemGroups.BLOCKS));
    }

    @Nullable
    public static ITextComponent checkForMissingLootTables(PlayerEntity player) {
        if (!(player.field_70170_p instanceof ServerWorld) || !SilentGems.isDevBuild()) {
            return null;
        }
        LootTableManager lootTableManager = ((ServerWorld)player.field_70170_p).func_73046_m().func_200249_aQ();
        ArrayList<String> missing = new ArrayList<String>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation lootTable = block.func_220068_i();
            if (!lootTable.func_110624_b().equals("silentgems") || block instanceof AirBlock || lootTableManager.func_215304_a().contains(lootTable)) continue;
            SilentGems.LOGGER.error("Missing block loot table '{}' for {}", (Object)lootTable, (Object)block.getRegistryName());
            missing.add(lootTable.toString());
        }
        if (!missing.isEmpty()) {
            String list = String.join((CharSequence)", ", missing);
            return new StringTextComponent("The following block loot tables are missing: " + list).func_240699_a_(TextFormatting.RED);
        }
        return null;
    }

    static {
        Gems.registerBlocks();
        TELEPORTER_ANCHOR = GemsBlocks.register("teleporter_anchor", () -> new TeleporterBaseBlock(true));
        MULTI_ORE_CLASSIC = GemsBlocks.register("multi_ore_classic", () -> new MultiGemOreBlock(Gems.Set.CLASSIC));
        MULTI_ORE_DARK = GemsBlocks.register("multi_ore_dark", () -> new MultiGemOreBlock(Gems.Set.DARK));
        MULTI_ORE_LIGHT = GemsBlocks.register("multi_ore_light", () -> new MultiGemOreBlock(Gems.Set.LIGHT));
        MiscBlocks.registerBlocks();
        MiscOres.registerBlocks();
        CorruptedBlocks.registerBlocks();
        HardenedRock.registerBlocks();
        WHITE_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.WHITE);
        ORANGE_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.ORANGE);
        MAGENTA_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.MAGENTA);
        LIGHT_BLUE_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.LIGHT_BLUE);
        YELLOW_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.YELLOW);
        LIME_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.LIME);
        PINK_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.PINK);
        GRAY_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.GRAY);
        LIGHT_GRAY_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.LIGHT_GRAY);
        CYAN_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.CYAN);
        PURPLE_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.PURPLE);
        BLUE_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.BLUE);
        BROWN_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.BROWN);
        GREEN_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.GREEN);
        RED_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.RED);
        BLACK_FLUFFY_BLOCK = GemsBlocks.registerFluffyBlock(DyeColor.BLACK);
        SOUL_URN = GemsBlocks.register("soul_urn", SoulUrnBlock::new, bro -> () -> new SoulUrnBlock.SoulUrnBlockItem((SoulUrnBlock)bro.get()));
        SUPERCHARGER = GemsBlocks.register("supercharger", SuperchargerBlock::new);
        TOKEN_ENCHANTER = GemsBlocks.register("token_enchanter", TokenEnchanterBlock::new);
        TRANSMUTATION_ALTAR = GemsBlocks.register("transmutation_altar", AltarBlock::new);
        PURIFIER = GemsBlocks.register("purifier", PurifierBlock::new);
        STONE_PEDESTAL = GemsBlocks.register("stone_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        GRANITE_PEDESTAL = GemsBlocks.register("granite_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        DIORITE_PEDESTAL = GemsBlocks.register("diorite_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        ANDESITE_PEDESTAL = GemsBlocks.register("andesite_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 5.0f).func_200947_a(SoundType.field_185851_d)));
        OBSIDIAN_PEDESTAL = GemsBlocks.register("obsidian_pedestal", () -> new PedestalBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(30.0f, 1200.0f).func_200947_a(SoundType.field_185851_d)));
        LUMINOUS_FLOWER_POT = GemsBlocks.register("luminous_flower_pot", LuminousFlowerPotBlock::new);
        PHANTOM_LIGHT = GemsBlocks.registerNoItem("phantom_light", PhantomLightBlock::new);
        FLUFFY_PUFF_PLANT = GemsBlocks.registerNoItem("fluffy_puff_plant", FluffyPuffPlant::new);
        WILD_FLUFFY_PUFF_PLANT = GemsBlocks.registerNoItem("wild_fluffy_puff_plant", WildFluffyPuffPlant::new);
    }
}

