/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.render.entity.CorruptedSlimeRenderer;
import net.silentchaos512.gems.client.render.entity.EnderSlimeRenderer;
import net.silentchaos512.gems.client.render.entity.WispRenderer;
import net.silentchaos512.gems.client.render.entity.WispShotRenderer;
import net.silentchaos512.gems.entity.AbstractWispEntity;
import net.silentchaos512.gems.entity.CorruptedSlimeEntity;
import net.silentchaos512.gems.entity.EnderSlimeEntity;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.utils.Lazy;

public final class GemsEntities {
    public static final Lazy<EntityType<EnderSlimeEntity>> ENDER_SLIME = GemsEntities.makeType("ender_slime", EnderSlimeEntity::new);
    public static final Lazy<EntityType<CorruptedSlimeEntity>> CORRUPTED_SLIME = GemsEntities.makeType("corrupted_slime", CorruptedSlimeEntity::new);

    private GemsEntities() {
    }

    public static void registerTypes(RegistryEvent.Register<EntityType<?>> event) {
        GemsEntities.registerType("ender_slime", (EntityType<? extends LivingEntity>)((EntityType)ENDER_SLIME.get()), EnderSlimeEntity.registerAttributes().func_233813_a_());
        GemsEntities.registerType("corrupted_slime", (EntityType<? extends LivingEntity>)((EntityType)CORRUPTED_SLIME.get()), CorruptedSlimeEntity.registerAttributes().func_233813_a_());
        for (WispTypes wispType : WispTypes.values()) {
            GemsEntities.registerType(wispType.getName(), wispType.getEntityType(), AbstractWispEntity.registerAttributes().func_233813_a_());
            GemsEntities.registerType(wispType.getName() + "_shot", wispType.getShotType());
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ENDER_SLIME.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EnderSlimeEntity::canSpawnAt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ENDER_SLIME.get()), EnderSlimeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CORRUPTED_SLIME.get()), CorruptedSlimeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.CHAOS.getEntityType(), WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.FIRE.getEntityType(), WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.ICE.getEntityType(), WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.LIGHTNING.getEntityType(), WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.WATER.getEntityType(), WispRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.CHAOS.getShotType(), WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.FIRE.getShotType(), WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.ICE.getShotType(), WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.LIGHTNING.getShotType(), WispShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WispTypes.WATER.getShotType(), WispShotRenderer::new);
    }

    private static <T extends Entity> Lazy<EntityType<T>> makeType(String name, EntityType.IFactory<T> factory) {
        return Lazy.of(() -> EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)EntityClassification.MONSTER).func_206830_a(SilentGems.getId(name).toString()));
    }

    private static void registerType(String name, EntityType<?> type) {
        ResourceLocation id = SilentGems.getId(name);
        type.setRegistryName(id);
        ForgeRegistries.ENTITIES.register(type);
    }

    private static void registerType(String name, EntityType<? extends LivingEntity> type, AttributeModifierMap modifierMap) {
        GemsEntities.registerType(name, type);
        GlobalEntityTypeAttributes.put(type, (AttributeModifierMap)modifierMap);
    }
}

