/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.gems.api.IPedestalItem;
import net.silentchaos512.gems.api.chaos.ChaosEmissionRate;
import net.silentchaos512.gems.capability.PedestalItemCapability;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.IGem;
import net.silentchaos512.gems.lib.chaosbuff.ChaosBuffManager;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;

public class ChaosGemItem
extends Item
implements IGem,
IPedestalItem {
    private static final String NBT_ENABLED = "Enabled";
    private static final String NBT_BUFF_LIST = "Buffs";
    private static final String NBT_BUFF_KEY = "ID";
    private static final String NBT_BUFF_LEVEL = "Level";
    private static final int MAX_SLOTS = 20;
    private static final int PEDESTAL_RANGE = 8;
    private final Gems gem;

    public ChaosGemItem(Gems gem) {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY).func_200917_a(1).func_208103_a(Rarity.RARE));
        this.gem = gem;
    }

    @Override
    public Gems getGem() {
        return this.gem;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == PedestalItemCapability.INSTANCE) {
                    return LazyOptional.of(() -> ((ItemStack)stack).func_77973_b()).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public static Map<IChaosBuff, Integer> getBuffs(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_196082_o().func_74764_b(NBT_BUFF_LIST)) {
            return new HashMap<IChaosBuff, Integer>();
        }
        ListNBT tagList = stack.func_196082_o().func_150295_c(NBT_BUFF_LIST, 10);
        LinkedHashMap<IChaosBuff, Integer> map = new LinkedHashMap<IChaosBuff, Integer>();
        for (INBT nbt : tagList) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT tag = (CompoundNBT)nbt;
            String key = tag.func_74779_i(NBT_BUFF_KEY);
            int level = tag.func_74762_e(NBT_BUFF_LEVEL);
            IChaosBuff buff = ChaosBuffManager.get(key);
            if (buff == null) continue;
            map.put(buff, level);
        }
        return map;
    }

    public static boolean addBuff(ItemStack stack, IChaosBuff buff) {
        if (ChaosGemItem.canAddBuff(stack, buff)) {
            Map<IChaosBuff, Integer> buffMap = ChaosGemItem.getBuffs(stack);
            int currentLevel = 0;
            if (buffMap.containsKey(buff)) {
                currentLevel = buffMap.get(buff);
            }
            buffMap.put(buff, currentLevel + 1);
            ChaosGemItem.setBuffs(stack, buffMap);
            return true;
        }
        return false;
    }

    public static void setBuffs(ItemStack stack, Map<IChaosBuff, Integer> buffs) {
        if (stack.func_190926_b()) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(NBT_BUFF_LIST)) {
            tag.func_82580_o(NBT_BUFF_LIST);
        }
        ListNBT tagList = new ListNBT();
        for (Map.Entry<IChaosBuff, Integer> entry : buffs.entrySet()) {
            IChaosBuff buff = entry.getKey();
            int level = entry.getValue();
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a(NBT_BUFF_KEY, buff.getId().toString());
            compound.func_74777_a(NBT_BUFF_LEVEL, (short)level);
            tagList.add((Object)compound);
        }
        tag.func_218657_a(NBT_BUFF_LIST, (INBT)tagList);
    }

    public static boolean canAddBuff(ItemStack stack, IChaosBuff buff) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return true;
        }
        Map<IChaosBuff, Integer> buffMap = ChaosGemItem.getBuffs(stack);
        if (buffMap.containsKey(buff)) {
            int currentLevel = buffMap.get(buff);
            if (currentLevel >= buff.getMaxLevel()) {
                return false;
            }
            buffMap.put(buff, currentLevel + 1);
        } else {
            buffMap.put(buff, 1);
        }
        return ChaosGemItem.getSlotsUsed(buffMap) <= 20;
    }

    public static int getSlotsUsed(ItemStack stack) {
        return ChaosGemItem.getSlotsUsed(ChaosGemItem.getBuffs(stack));
    }

    public static int getSlotsUsed(Map<IChaosBuff, Integer> buffMap) {
        return buffMap.entrySet().stream().mapToInt(entry -> ((IChaosBuff)entry.getKey()).getSlotsForLevel((Integer)entry.getValue())).sum();
    }

    public static int getChaosGenerated(ItemStack stack, PlayerEntity player) {
        return ChaosGemItem.getBuffs(stack).entrySet().stream().mapToInt(entry -> ((IChaosBuff)entry.getKey()).getChaosGenerated(player, (Integer)entry.getValue())).sum();
    }

    public static int getMaxChaosGenerated(ItemStack stack) {
        return ChaosGemItem.getBuffs(stack).entrySet().stream().mapToInt(entry -> ((IChaosBuff)entry.getKey()).getActiveChaosGenerated((Integer)entry.getValue())).sum();
    }

    public static boolean isEnabled(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74767_n(NBT_ENABLED);
    }

    public static void setEnabled(ItemStack stack, boolean value) {
        if (stack.func_190926_b()) {
            return;
        }
        stack.func_196082_o().func_74757_a(NBT_ENABLED, value);
    }

    public static int getBuffLevel(ItemStack stack, IChaosBuff buff) {
        Map<IChaosBuff, Integer> buffMap = ChaosGemItem.getBuffs(stack);
        return buffMap.getOrDefault(buff, 0);
    }

    public static void applyEffects(ItemStack stack, PlayerEntity player) {
        ChaosGemItem.getBuffs(stack).forEach((buff, level) -> buff.applyTo(player, (int)level));
    }

    public static void removeEffects(ItemStack stack, PlayerEntity player) {
        ChaosGemItem.getBuffs(stack).keySet().forEach(buff -> buff.removeFrom(player));
    }

    @Override
    public boolean pedestalPowerChange(ItemStack stack, World world, BlockPos pos, boolean powered) {
        ChaosGemItem.setEnabled(stack, powered);
        return true;
    }

    @Override
    public void pedestalTick(ItemStack stack, World world, BlockPos pos) {
        if (world.field_72995_K || !ChaosGemItem.isEnabled(stack)) {
            return;
        }
        int totalChaos = 0;
        AxisAlignedBB boundingBox = new AxisAlignedBB(pos).func_186662_g(8.0);
        List players = world.func_217357_a(PlayerEntity.class, boundingBox);
        for (PlayerEntity player : players) {
            ChaosGemItem.applyEffects(stack, player);
            totalChaos += ChaosGemItem.getChaosGenerated(stack, player);
        }
        float divisor = 1.0f + 0.25f * (float)(players.size() - 1);
        int discountedChaos = (int)((float)totalChaos / divisor);
        Chaos.generate((ICapabilityProvider)world, discountedChaos, pos);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        if (ChaosGemItem.isEnabled(stack)) {
            PlayerEntity player = (PlayerEntity)entity;
            ChaosGemItem.applyEffects(stack, player);
            Chaos.generate(player, ChaosGemItem.getChaosGenerated(stack, player), true);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        ChaosGemItem.setEnabled(stack, false);
        ChaosGemItem.removeEffects(stack, player);
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            ChaosGemItem.setEnabled(stack, !ChaosGemItem.isEnabled(stack));
            if (ChaosGemItem.isEnabled(stack)) {
                ChaosGemItem.applyEffects(stack, player);
            } else {
                ChaosGemItem.removeEffects(stack, player);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ChaosGemItem.getBuffs(stack).forEach((buff, level) -> tooltip.add(buff.getDisplayName((int)level)));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.silentgems.chaos_gem.slots", new Object[]{ChaosGemItem.getSlotsUsed(stack), 20}));
        tooltip.add(ChaosGemItem.chaosGenTooltip("item.silentgems.chaos_gem.chaos", ChaosGemItem.getChaosGenerated(stack, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)));
        tooltip.add(ChaosGemItem.chaosGenTooltip("item.silentgems.chaos_gem.chaosMax", ChaosGemItem.getMaxChaosGenerated(stack)));
    }

    private static ITextComponent chaosGenTooltip(String key, int chaos) {
        ChaosEmissionRate emissionRate = ChaosEmissionRate.fromAmount(chaos);
        return new TranslationTextComponent(key, new Object[]{emissionRate.getDisplayName(chaos)});
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return this.func_200296_o();
    }

    public ITextComponent func_200296_o() {
        return new TranslationTextComponent("item.silentgems.chaos_gem", new Object[]{this.gem.getDisplayName()});
    }

    public boolean func_77636_d(ItemStack stack) {
        return ChaosGemItem.isEnabled(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean oldEnabled = ChaosGemItem.isEnabled(oldStack);
        boolean newEnabled = ChaosGemItem.isEnabled(newStack);
        return slotChanged || oldEnabled != newEnabled || !oldStack.func_77969_a(newStack);
    }
}

