/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.block.GemBricksBlock;
import net.silentchaos512.gems.block.GemGlassBlock;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.GemOreBlock;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.PottedGlowroseBlock;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.RedstoneGemTeleporterBlock;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.ChaosGemItem;
import net.silentchaos512.gems.item.GemBlockItem;
import net.silentchaos512.gems.item.GemItem;
import net.silentchaos512.gems.item.GemShardItem;
import net.silentchaos512.gems.item.ReturnHomeCharmItem;
import net.silentchaos512.gems.lib.IGem;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.utils.Color;

public enum Gems {
    RUBY(Set.CLASSIC, 15080733),
    GARNET(Set.CLASSIC, 15093533),
    TOPAZ(Set.CLASSIC, 15102237),
    AMBER(Set.CLASSIC, 15115037),
    HELIODOR(Set.CLASSIC, 15123741),
    PERIDOT(Set.CLASSIC, 10741277),
    GREEN_SAPPHIRE(Set.CLASSIC, 1959453),
    PHOSPHOPHYLLITE(Set.CLASSIC, 1959554),
    AQUAMARINE(Set.CLASSIC, 1959654),
    SAPPHIRE(Set.CLASSIC, 1908198),
    TANZANITE(Set.CLASSIC, 6299110),
    AMETHYST(Set.CLASSIC, 10690022),
    AGATE(Set.CLASSIC, 15080934),
    MORGANITE(Set.CLASSIC, 0xFF88FE),
    ONYX(Set.CLASSIC, 0x2F2F2F),
    OPAL(Set.CLASSIC, 0xE4E4E4),
    CARNELIAN(Set.DARK, 10685952),
    SPINEL(Set.DARK, 10699776),
    CITRINE(Set.DARK, 10706688),
    JASPER(Set.DARK, 10717184),
    ZIRCON(Set.DARK, 0xA3A300),
    MOLDAVITE(Set.DARK, 8954624),
    MALACHITE(Set.DARK, 41782),
    TURQUOISE(Set.DARK, 41864),
    EUCLASE(Set.DARK, 28067),
    BENITOITE(Set.DARK, 7075),
    IOLITE(Set.DARK, 6226083),
    ALEXANDRITE(Set.DARK, 9765027),
    LEPIDOLITE(Set.DARK, 10682490),
    AMETRINE(Set.DARK, 10682450),
    BLACK_DIAMOND(Set.DARK, 0x1E1E1E),
    MOONSTONE(Set.DARK, 0x898989),
    PYROPE(Set.LIGHT, 16729460),
    CORAL(Set.LIGHT, 0xFF5545),
    SUNSTONE(Set.LIGHT, 16741445),
    CATS_EYE(Set.LIGHT, 16761157),
    YELLOW_DIAMOND(Set.LIGHT, 0xFFFF45),
    JADE(Set.LIGHT, 10682181),
    CHRYSOPRASE(Set.LIGHT, 6618949),
    APATITE(Set.LIGHT, 4587473),
    FLUORITE(Set.LIGHT, 4575743),
    KYANITE(Set.LIGHT, 4555775),
    SODALITE(Set.LIGHT, 0x5445FF),
    AMMOLITE(Set.LIGHT, 14697983),
    KUNZITE(Set.LIGHT, 16729568),
    ROSE_QUARTZ(Set.LIGHT, 16742582),
    TEKTITE(Set.LIGHT, 9403499),
    PEARL(Set.LIGHT, 14870769);

    final Set set;
    final Color color;
    BlockRegistryObject<GemOreBlock> ore;
    BlockRegistryObject<GemBlock> block;
    BlockRegistryObject<GemBricksBlock> bricks;
    BlockRegistryObject<GemGlassBlock> glass;
    BlockRegistryObject<GemLampBlock> lampUnlit;
    BlockRegistryObject<GemLampBlock> lampLit;
    BlockRegistryObject<GemLampBlock> lampInvertedLit;
    BlockRegistryObject<GemLampBlock> lampInvertedUnlit;
    BlockRegistryObject<GemTeleporterBlock> teleporter;
    BlockRegistryObject<RedstoneGemTeleporterBlock> redstoneTeleporter;
    BlockRegistryObject<GlowroseBlock> glowrose;
    BlockRegistryObject<FlowerPotBlock> pottedGlowrose;
    ItemRegistryObject<GemItem> item;
    ItemRegistryObject<GemShardItem> shard;
    ItemRegistryObject<ReturnHomeCharmItem> returnHomeCharm;
    ItemRegistryObject<ChaosGemItem> chaosGem;
    final ITag.INamedTag<Block> blockTag;
    final ITag.INamedTag<Block> glowroseTag;
    final ITag.INamedTag<Block> oreTag;
    final ITag.INamedTag<Item> blockItemTag;
    final ITag.INamedTag<Item> glowroseItemTag;
    final ITag.INamedTag<Item> oreItemTag;
    final ITag.INamedTag<Item> itemTag;
    final ITag.INamedTag<Item> shardTag;

    private Gems(Set set, int color) {
        this.set = set;
        this.set.gems.add(this);
        this.color = new Color(color);
        this.blockTag = BlockTags.func_199894_a((String)new ResourceLocation("forge", "storage_blocks/" + this.getName()).toString());
        this.glowroseTag = BlockTags.func_199894_a((String)SilentGems.getId("glowroses/" + this.getName()).toString());
        this.oreTag = BlockTags.func_199894_a((String)new ResourceLocation("forge", "ores/" + this.getName()).toString());
        this.blockItemTag = ItemTags.func_199901_a((String)new ResourceLocation("forge", "storage_blocks/" + this.getName()).toString());
        this.glowroseItemTag = ItemTags.func_199901_a((String)SilentGems.getId("glowroses/" + this.getName()).toString());
        this.oreItemTag = ItemTags.func_199901_a((String)new ResourceLocation("forge", "ores/" + this.getName()).toString());
        this.itemTag = ItemTags.func_199901_a((String)new ResourceLocation("forge", "gems/" + this.getName()).toString());
        this.shardTag = ItemTags.func_199901_a((String)new ResourceLocation("forge", "nuggets/" + this.getName()).toString());
    }

    public static void registerBlocks() {
        for (Gems gem : Gems.values()) {
            gem.ore = Gems.registerBlock(gem.getName() + "_ore", () -> new GemOreBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.block = Gems.registerBlock(gem.getName() + "_block", () -> new GemBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.bricks = Gems.registerBlock(gem.getName() + "_bricks", () -> new GemBricksBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.glass = Gems.registerBlock(gem.getName() + "_glass", () -> new GemGlassBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.lampUnlit = Gems.registerBlock(gem.getName() + "_lamp", () -> new GemLampBlock(gem, GemLampBlock.State.UNLIT, AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200948_a(0.3f, 15.0f).func_235838_a_(state -> 0)));
        }
        for (Gems gem : Gems.values()) {
            gem.lampLit = Gems.registerBlockNoItem(gem.getName() + "_lamp_lit", () -> new GemLampBlock(gem, GemLampBlock.State.LIT, AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200948_a(0.3f, 15.0f).func_235838_a_(state -> 15).func_222379_b((Block)gem.getLamp(GemLampBlock.State.UNLIT))));
        }
        for (Gems gem : Gems.values()) {
            gem.lampInvertedLit = Gems.registerBlock(gem.getName() + "_lamp_inverted_lit", () -> new GemLampBlock(gem, GemLampBlock.State.INVERTED_LIT, AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200948_a(0.3f, 15.0f).func_235838_a_(state -> 15)));
        }
        for (Gems gem : Gems.values()) {
            gem.lampInvertedUnlit = Gems.registerBlockNoItem(gem.getName() + "_lamp_inverted", () -> new GemLampBlock(gem, GemLampBlock.State.INVERTED_UNLIT, AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200948_a(0.3f, 15.0f).func_235838_a_(state -> 0).func_222379_b((Block)gem.getLamp(GemLampBlock.State.INVERTED_LIT))));
        }
        for (Gems gem : Gems.values()) {
            gem.glowrose = Gems.registerBlock(gem.getName() + "_glowrose", () -> new GlowroseBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.pottedGlowrose = Gems.registerBlockNoItem("potted_" + gem.getName() + "_glowrose", () -> new PottedGlowroseBlock(gem, (Supplier<GlowroseBlock>)gem.glowrose));
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(SilentGems.getId(gem.getName() + "_glowrose"), gem.pottedGlowrose);
        }
        for (Gems gem : Gems.values()) {
            gem.teleporter = Gems.registerBlock(gem.getName() + "_teleporter", () -> new GemTeleporterBlock(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.redstoneTeleporter = Gems.registerBlock(gem.getName() + "_redstone_teleporter", () -> new RedstoneGemTeleporterBlock(gem));
        }
    }

    public static void registerItems() {
        for (Gems gem : Gems.values()) {
            gem.item = Gems.registerItem(gem.getName(), () -> new GemItem(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.shard = Gems.registerItem(gem.getName() + "_shard", () -> new GemShardItem(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.returnHomeCharm = Gems.registerItem(gem.getName() + "_return_home_charm", () -> new ReturnHomeCharmItem(gem));
        }
        for (Gems gem : Gems.values()) {
            gem.chaosGem = Gems.registerItem("chaos_" + gem.getName(), () -> new ChaosGemItem(gem));
        }
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlockNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return Gems.registerBlock(name, block, Gems::defaultBlockItem);
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlock(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<BlockItem>> item) {
        BlockRegistryObject<T> ret = Gems.registerBlockNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static <T extends Item> ItemRegistryObject<T> registerItem(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    private static Supplier<BlockItem> defaultBlockItem(BlockRegistryObject<?> block) {
        return () -> new GemBlockItem((Block)block.get(), new Item.Properties().func_200916_a(GemsItemGroups.BLOCKS));
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getColor() {
        return this.color.getColor();
    }

    public Color getColorObj() {
        return this.color;
    }

    public float[] getColorArray() {
        return new float[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("gem.silentgems." + this.getName());
    }

    @Nullable
    public static Gems from(ItemStack stack) {
        return Gems.from(stack, true);
    }

    @Nullable
    public static Gems from(ItemStack stack, boolean matchTag) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof IGem) {
                return ((IGem)item).getGem();
            }
            if (matchTag) {
                for (Gems gem : Gems.values()) {
                    if (!gem.itemTag.func_230235_a_((Object)item)) continue;
                    return gem;
                }
            }
        }
        return null;
    }

    @Nullable
    public static Gems fromName(String name) {
        for (Gems gem : Gems.values()) {
            if (!name.equalsIgnoreCase(gem.name())) continue;
            return gem;
        }
        return null;
    }

    public static Gems selectRandom() {
        return Gems.selectRandom(SilentGems.random);
    }

    public static Gems selectRandom(Random random) {
        return Gems.values()[random.nextInt(Gems.values().length)];
    }

    public GemBlock getBlock() {
        return (GemBlock)this.block.get();
    }

    public GemBricksBlock getBricks() {
        return (GemBricksBlock)this.bricks.get();
    }

    public GemGlassBlock getGlass() {
        return (GemGlassBlock)this.glass.get();
    }

    public GemLampBlock getLamp(GemLampBlock.State state) {
        if (state == GemLampBlock.State.UNLIT) {
            return (GemLampBlock)this.lampUnlit.get();
        }
        if (state == GemLampBlock.State.LIT) {
            return (GemLampBlock)this.lampLit.get();
        }
        if (state == GemLampBlock.State.INVERTED_LIT) {
            return (GemLampBlock)this.lampInvertedLit.get();
        }
        if (state == GemLampBlock.State.INVERTED_UNLIT) {
            return (GemLampBlock)this.lampInvertedUnlit.get();
        }
        throw new IllegalArgumentException("Unknown GemLampBlock.State: " + (Object)((Object)state));
    }

    public GemOreBlock getOre() {
        return (GemOreBlock)this.ore.get();
    }

    public GlowroseBlock getGlowrose() {
        return (GlowroseBlock)this.glowrose.get();
    }

    public FlowerPotBlock getPottedGlowrose() {
        return (FlowerPotBlock)this.pottedGlowrose.get();
    }

    public GemTeleporterBlock getTeleporter() {
        return (GemTeleporterBlock)this.teleporter.get();
    }

    public RedstoneGemTeleporterBlock getRedstoneTeleporter() {
        return (RedstoneGemTeleporterBlock)this.redstoneTeleporter.get();
    }

    public GemItem getItem() {
        return (GemItem)this.item.get();
    }

    public ItemStack getItemStack() {
        return new ItemStack((IItemProvider)this.item.get());
    }

    public ITag.INamedTag<Block> getBlockTag() {
        return this.blockTag;
    }

    public ITag.INamedTag<Item> getBlockItemTag() {
        return this.blockItemTag;
    }

    public ITag.INamedTag<Block> getGlowroseTag() {
        return this.glowroseTag;
    }

    public ITag.INamedTag<Item> getGlowroseItemTag() {
        return this.glowroseItemTag;
    }

    public ITag.INamedTag<Block> getOreTag() {
        return this.oreTag;
    }

    public ITag.INamedTag<Item> getOreItemTag() {
        return this.oreItemTag;
    }

    public ITag.INamedTag<Item> getItemTag() {
        return this.itemTag;
    }

    public ITag.INamedTag<Item> getShardTag() {
        return this.shardTag;
    }

    public GemShardItem getShard() {
        return (GemShardItem)this.shard.get();
    }

    public ReturnHomeCharmItem getReturnHomeCharm() {
        return (ReturnHomeCharmItem)this.returnHomeCharm.get();
    }

    public ChaosGemItem getChaosGem() {
        return (ChaosGemItem)this.chaosGem.get();
    }

    public Set getSet() {
        return this.set;
    }

    public static enum Set implements Iterable<Gems>
    {
        CLASSIC(0, HardenedRock.STONE),
        DARK(16, HardenedRock.NETHERRACK),
        LIGHT(32, HardenedRock.END_STONE);

        public static final Codec<Set> CODEC;
        private final int startMeta;
        private final IBlockProvider geodeShell;
        private final Collection<Gems> gems = new ArrayList<Gems>();

        private Set(int startMeta, IBlockProvider geodeShell) {
            this.startMeta = startMeta;
            this.geodeShell = geodeShell;
        }

        public static Set forDimension(RegistryKey<World> dimension) {
            if (dimension == World.field_234919_h_) {
                return DARK;
            }
            if (dimension == World.field_234920_i_) {
                return LIGHT;
            }
            return CLASSIC;
        }

        public SoundType getOreSoundType() {
            if (this == DARK) {
                return SoundType.field_235592_N_;
            }
            return SoundType.field_185851_d;
        }

        public Gems getSetIcon() {
            if (this == CLASSIC) {
                return PHOSPHOPHYLLITE;
            }
            if (this == DARK) {
                return CITRINE;
            }
            if (this == LIGHT) {
                return KYANITE;
            }
            throw new NullPointerException("Non-existent Gems.Set, wat?");
        }

        private static DataResult<Set> decode(int encodedIn) {
            if (encodedIn >= 0 && encodedIn < Set.values().length) {
                return DataResult.success((Object)Set.values()[encodedIn]);
            }
            return DataResult.error((String)("Not a valid gem set index: " + encodedIn));
        }

        public IBlockProvider getGeodeShell() {
            return this.geodeShell;
        }

        public Gems selectRandom(Random random) {
            int id = random.nextInt(16) + this.startMeta;
            return Gems.values()[id];
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public ITextComponent getDisplayName() {
            TranslationTextComponent textSet = new TranslationTextComponent("gem.silentgems.set." + this.getName());
            return new TranslationTextComponent("gem.silentgems.set", new Object[]{textSet}).func_240699_a_(TextFormatting.ITALIC);
        }

        @Override
        public Iterator<Gems> iterator() {
            return this.gems.iterator();
        }

        static {
            CODEC = Codec.INT.comapFlatMap(Set::decode, Enum::ordinal);
        }
    }
}

