/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.urn;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.SoulUrnTileEntity;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class UpgradePlanter
extends UrnUpgrade {
    private static final int TICK_FREQUENCY = TimeUtils.ticksFromSeconds((float)30.0f);
    private static final Map<IItemProvider, Plant> PLANTS = new HashMap<IItemProvider, Plant>();
    private int ticks = 0;
    private static boolean initialized = false;

    @Override
    public void tickTile(SoulUrnTileEntity.SoulUrnState state, World world, BlockPos pos) {
        if (!state.getLidState().isOpen()) {
            return;
        }
        ++this.ticks;
        if (this.ticks >= TICK_FREQUENCY) {
            Plant plant;
            this.ticks = 0;
            ItemStack seed = UpgradePlanter.getSeed(state);
            if (!seed.func_190926_b() && (plant = PLANTS.get(seed.func_77973_b())) != null) {
                InventoryUtils.mergeItems((IInventory)state.getTileEntity(), (int)0, (int)state.getTileEntity().func_70302_i_(), (Collection)((Collection)plant.drops.apply(SilentGems.random)));
            }
        }
    }

    @Override
    public void tickItem(ItemStack urn, World world, PlayerEntity player, int itemSlot, boolean isSelected) {
    }

    private static ItemStack getSeed(SoulUrnTileEntity.SoulUrnState state) {
        IItemHandler itemHandler = (IItemHandler)state.getTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(IllegalStateException::new);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!UpgradePlanter.isGrowablePlant(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        PLANTS.put((IItemProvider)Items.field_185163_cU, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_185164_cV), 1.0, new ItemStack((IItemProvider)Items.field_185163_cU), 0.5)));
        PLANTS.put((IItemProvider)Items.field_151172_bF, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_151172_bF), 1.0)));
        PLANTS.put((IItemProvider)Blocks.field_185766_cS, new Plant(2, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_185161_cS), 1.0, new ItemStack((IItemProvider)Blocks.field_185766_cS), 0.05)));
        PLANTS.put((IItemProvider)Items.field_151081_bc, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_151127_ba, random.nextInt(4) + 1), 0.85, new ItemStack((IItemProvider)Blocks.field_150440_ba), 0.2)));
        PLANTS.put((IItemProvider)Items.field_151075_bm, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_151075_bm, random.nextInt(3) + 1), 0.95)));
        PLANTS.put((IItemProvider)Items.field_151174_bG, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_151174_bG), 1.0, new ItemStack((IItemProvider)Items.field_151170_bI), 0.05)));
        PLANTS.put((IItemProvider)Items.field_151080_bb, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Blocks.field_150423_aK), 0.85, new ItemStack((IItemProvider)Blocks.field_196628_cT), 0.01)));
        PLANTS.put((IItemProvider)Blocks.field_196608_cF, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Blocks.field_196608_cF, random.nextInt(2) + 1), 0.85)));
        PLANTS.put((IItemProvider)Items.field_151014_N, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack((IItemProvider)Items.field_151015_O), 1.0, new ItemStack((IItemProvider)Items.field_151014_N), 0.5)));
    }

    private static boolean isGrowablePlant(ItemStack stack) {
        return !stack.func_190926_b() && PLANTS.containsKey(stack.func_77973_b());
    }

    private static Collection<ItemStack> dropsWithChance(Random random, ItemStack stack1, double rate1) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!stack1.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate1)) {
            builder.add((Object)stack1);
        }
        return builder.build();
    }

    private static Collection<ItemStack> dropsWithChance(Random random, ItemStack stack1, double rate1, ItemStack stack2, double rate2) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!stack1.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate1)) {
            builder.add((Object)stack1);
        }
        if (!stack2.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate2)) {
            builder.add((Object)stack2);
        }
        return builder.build();
    }

    public static class Plant {
        private final int growthTicks;
        private final Function<Random, Collection<ItemStack>> drops;

        public Plant(int growthRate, Function<Random, Collection<ItemStack>> drops) {
            this.growthTicks = growthRate;
            this.drops = drops;
        }
    }
}

