/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.silentchaos512.gems.init.GemsLoot;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.Soul;

public class SetSoulFunction
extends LootFunction {
    public static final Serializer SERIALIZER = new Serializer();
    private final String soulId;

    protected SetSoulFunction(ILootCondition[] conditionsIn, String soulId) {
        super(conditionsIn);
        this.soulId = soulId;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        ItemStack result = stack.func_77946_l();
        Soul soul = Soul.from(this.soulId);
        if (soul != null) {
            SoulGemItem.setSoul(result, soul);
        }
        return result;
    }

    public static ILootFunction.IBuilder builder(Soul soul) {
        return SetSoulFunction.func_215860_a(conditions -> new SetSoulFunction((ILootCondition[])conditions, soul.getId().toString()));
    }

    public LootFunctionType func_230425_b_() {
        return GemsLoot.SET_SOUL;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetSoulFunction> {
        public void serialize(JsonObject json, SetSoulFunction value, JsonSerializationContext serializationContext) {
            json.addProperty("soul", value.soulId);
        }

        public SetSoulFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            String soulId = JSONUtils.func_151200_h((JsonObject)json, (String)"soul");
            return new SetSoulFunction(conditionsIn, soulId);
        }
    }
}

