/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetScreenData {
    private String modid;
    private GlobalPos pos;
    private long millis;

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.modid);
        buf.func_179255_a(this.pos.func_218180_b());
        buf.func_192572_a(this.pos.func_239646_a_().func_240901_a_());
        buf.writeLong(this.millis);
    }

    public PacketGetScreenData() {
    }

    public PacketGetScreenData(PacketBuffer buf) {
        this.modid = buf.func_150789_c(Short.MAX_VALUE);
        BlockPos pos = buf.func_179259_c();
        RegistryKey id = LevelTools.getId((ResourceLocation)buf.func_192575_l());
        this.pos = GlobalPos.func_239648_a_((RegistryKey)id, (BlockPos)pos);
        this.millis = buf.readLong();
    }

    public PacketGetScreenData(String modid, GlobalPos pos, long millis) {
        this.modid = modid;
        this.pos = pos;
        this.millis = millis;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            if ((world = LevelTools.getLevel((World)world, (RegistryKey)this.pos.func_239646_a_())).func_175667_e(this.pos.func_218180_b())) {
                TileEntity te = world.func_175625_s(this.pos.func_218180_b());
                if (!(te instanceof ScreenTileEntity)) {
                    Logging.logError((String)"PacketGetScreenData: TileEntity is not a ScreenTileEntity!");
                    return;
                }
                Map<Integer, IModuleData> screenData = ((ScreenTileEntity)te).getScreenData(this.millis);
                PacketReturnScreenData msg = new PacketReturnScreenData(this.pos, screenData);
                RFToolsUtilityMessages.INSTANCE.sendTo((Object)msg, ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

