/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.xnet.XNet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class ConnectorClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ConsumerId consumerId;
    @Nonnull
    private final IChannelType channelType;
    @Nonnull
    private final IConnectorSettings connectorSettings;

    public ConnectorClientInfo(@Nonnull SidedPos pos, @Nonnull ConsumerId consumerId, @Nonnull IChannelType channelType, @Nonnull IConnectorSettings connectorSettings) {
        this.pos = pos;
        this.consumerId = consumerId;
        this.channelType = channelType;
        this.connectorSettings = connectorSettings;
    }

    public ConnectorClientInfo(@Nonnull PacketBuffer buf) {
        this.pos = new SidedPos(buf.func_179259_c(), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
        this.consumerId = new ConsumerId(buf.readInt());
        IChannelType t = XNet.xNetApi.findType(buf.func_150789_c(Short.MAX_VALUE));
        if (t == null) {
            throw new RuntimeException("Cannot happen!");
        }
        this.channelType = t;
        CompoundNBT tag = buf.func_150793_b();
        this.connectorSettings = this.channelType.createConnector(this.pos.getSide());
        this.connectorSettings.readFromNBT(tag);
    }

    public void writeToBuf(@Nonnull PacketBuffer buf) {
        buf.func_179255_a(this.pos.getPos());
        buf.writeByte(this.pos.getSide().ordinal());
        buf.writeInt(this.consumerId.getId());
        buf.func_180714_a(this.channelType.getID());
        CompoundNBT tag = new CompoundNBT();
        this.connectorSettings.writeToNBT(tag);
        buf.func_150786_a(tag);
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    @Nonnull
    public IConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }
}

