/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.lib;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Localization {
    public static String keyString(String domain, IForgeRegistryEntry<?> entry, String path) {
        ResourceLocation location = entry.getRegistryName();
        assert (location != null);
        return Localization.keyString(domain, location.func_110623_a() + "." + path);
    }

    public static String keyString(String domain, String path) {
        return domain + "." + "solcarrot" + "." + path;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localized(String domain, IForgeRegistryEntry<?> entry, String path, Object ... args) {
        return I18n.func_135052_a((String)Localization.keyString(domain, entry, path), (Object[])args);
    }

    public static IFormattableTextComponent localizedComponent(String domain, IForgeRegistryEntry<?> entry, String path, Object ... args) {
        return new TranslationTextComponent(Localization.keyString(domain, entry, path), args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localized(String domain, String path, Object ... args) {
        return I18n.func_135052_a((String)Localization.keyString(domain, path), (Object[])args);
    }

    public static IFormattableTextComponent localizedComponent(String domain, String path, Object ... args) {
        return new TranslationTextComponent(Localization.keyString(domain, path), args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localizedQuantity(String domain, String path, int number) {
        return number == 1 ? I18n.func_135052_a((String)Localization.keyString(domain, path + ".singular"), (Object[])new Object[0]) : I18n.func_135052_a((String)Localization.keyString(domain, path + ".plural"), (Object[])new Object[]{number});
    }

    public static IFormattableTextComponent localizedQuantityComponent(String domain, String path, int number) {
        return number == 1 ? new TranslationTextComponent(Localization.keyString(domain, path + ".singular")) : new TranslationTextComponent(Localization.keyString(domain, path + ".plural"), new Object[]{number});
    }

    public static String formatBigNumber(int number) {
        if (number < 1000) {
            return "" + number;
        }
        if (number < 10000) {
            return Math.round((float)number / 1000.0f) + "." + Math.round((float)(number % 1000) / 100.0f) + "k";
        }
        return Math.round((float)number / 1000.0f) + "k";
    }

    private Localization() {
    }
}

