/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import genetics.api.individual.IGenome;
import javax.annotation.Nullable;

public class BeeHousingModifier
implements IBeeModifier {
    private final IBeeHousing beeHousing;

    public BeeHousingModifier(IBeeHousing beeHousing) {
        this.beeHousing = beeHousing;
    }

    @Override
    public float getTerritoryModifier(IGenome genome, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getTerritoryModifier(genome, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public float getMutationModifier(IGenome genome, IGenome mate, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getMutationModifier(genome, mate, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public float getLifespanModifier(IGenome genome, @Nullable IGenome mate, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getLifespanModifier(genome, mate, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public float getProductionModifier(IGenome genome, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getProductionModifier(genome, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public float getFloweringModifier(IGenome genome, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getFloweringModifier(genome, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public float getGeneticDecay(IGenome genome, float currentModifier) {
        float modifierValue = 1.0f;
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            modifierValue *= modifier.getGeneticDecay(genome, modifierValue * currentModifier);
        }
        return modifierValue;
    }

    @Override
    public boolean isSealed() {
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            if (!modifier.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            if (!modifier.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            if (!modifier.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        for (IBeeModifier modifier : this.beeHousing.getBeeModifiers()) {
            if (!modifier.isHellish()) continue;
            return true;
        }
        return false;
    }
}

