/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.network.packets.PacketBeeLogicActive;
import forestry.apiculture.tiles.TileHive;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldgenBeekeepingLogic
implements IBeekeepingLogic {
    private final TileHive housing;
    private final IEffectData[] effectData = new IEffectData[2];
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache(2);
    private final TickHelper tickHelper = new TickHelper();
    private boolean active;

    public WorldgenBeekeepingLogic(TileHive housing) {
        this.housing = housing;
    }

    @Override
    public void read(CompoundNBT CompoundNBT2) {
        this.setActive(CompoundNBT2.func_74767_n("Active"));
        this.hasFlowersCache.read(CompoundNBT2);
    }

    @Override
    public CompoundNBT write(CompoundNBT CompoundNBT2) {
        CompoundNBT2.func_74757_a("Active", this.active);
        this.hasFlowersCache.write(CompoundNBT2);
        return CompoundNBT2;
    }

    @Override
    public void writeData(PacketBuffer data) {
        data.writeBoolean(this.active);
        if (this.active) {
            this.hasFlowersCache.writeData(data);
        }
    }

    @Override
    public void readData(PacketBuffer data) {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.hasFlowersCache.readData(data);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        this.tickHelper.onTick();
        if (this.tickHelper.updateOnInterval(200)) {
            IBee queen = this.housing.getContainedBee();
            this.hasFlowersCache.update(queen, this.housing);
            World world = this.housing.getWorldObj();
            boolean canWork = !(!world.func_72935_r() && queen.getGenome().getActiveValue(BeeChromosomes.NEVER_SLEEPS) == false || this.housing.isRaining() && queen.getGenome().getActiveValue(BeeChromosomes.TOLERATES_RAIN) == false);
            boolean flowerCacheNeedsSync = this.hasFlowersCache.needsSync();
            if (this.active != canWork) {
                this.setActive(canWork);
            } else if (flowerCacheNeedsSync) {
                this.syncToClient();
            }
        }
        return this.active;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void clearCachedValues() {
    }

    @Override
    public void syncToClient() {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketBeeLogicActive(this.housing), this.housing.getCoordinates(), world);
        }
    }

    @Override
    public void syncToClient(ServerPlayerEntity player) {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            NetworkUtil.sendToPlayer(new PacketBeeLogicActive(this.housing), (PlayerEntity)player);
        }
    }

    @Override
    public int getBeeProgressPercent() {
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canDoBeeFX() {
        return !Minecraft.func_71410_x().func_147113_T() && this.active;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doBeeFX() {
        IBee queen = this.housing.getContainedBee();
        queen.doFX(this.effectData, this.housing);
    }

    @Override
    public List<BlockPos> getFlowerPositions() {
        return this.hasFlowersCache.getFlowerCoords();
    }
}

