/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeEffect;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeMutation;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.TextCompound;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.flowers.IFlowerProvider;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import forestry.core.utils.VectUtil;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKeys;
import genetics.individual.Genome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class Bee
extends IndividualLiving
implements IBee {
    private static final String NBT_NATURAL = "NA";
    private static final String NBT_GENERATION = "GEN";
    private int generation;
    private boolean isNatural = true;

    public Bee(CompoundNBT nbt) {
        super(nbt);
        if (nbt.func_74764_b(NBT_NATURAL)) {
            this.isNatural = nbt.func_74767_n(NBT_NATURAL);
        }
        if (nbt.func_74764_b(NBT_GENERATION)) {
            this.generation = nbt.func_74762_e(NBT_GENERATION);
        }
    }

    public Bee(IGenome genome) {
        this(genome, (IGenome)null);
    }

    public Bee(IGenome genome, IBee mate) {
        this(genome, mate.getGenome());
    }

    public Bee(IGenome genome, @Nullable IGenome mate) {
        this(genome, mate, true, 0);
    }

    private Bee(IGenome genome, @Nullable IGenome mate, boolean isNatural, int generation) {
        super(genome, mate, genome.getActiveValue(BeeChromosomes.LIFESPAN));
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public IIndividualRoot getRoot() {
        return BeeManager.beeRoot;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound = super.write(compound);
        if (!this.isNatural) {
            compound.func_74757_a(NBT_NATURAL, false);
        }
        if (this.generation > 0) {
            compound.func_74768_a(NBT_GENERATION, this.generation);
        }
        return compound;
    }

    @Override
    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    @Override
    public boolean isNatural() {
        return this.isNatural;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getActiveAllele(BeeChromosomes.EFFECT);
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = this.genome.getInactiveAllele(BeeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getActiveAllele(BeeChromosomes.EFFECT);
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = this.genome.getInactiveAllele(BeeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    @OnlyIn(value=Dist.CLIENT)
    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public IBee copy() {
        CompoundNBT compound = new CompoundNBT();
        this.write(compound);
        return new Bee(compound);
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public Set<IErrorState> getCanWork(IBeeHousing housing) {
        EnumTolerance beeToleranceHumidity;
        EnumHumidity beeBaseHumidity;
        EnumHumidity actualHumidity;
        EnumTolerance beeToleranceTemperature;
        EnumTemperature beeBaseTemperature;
        World world = housing.getWorldObj();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        if (housing.isRaining() && !this.canFlyInRain(beeModifier)) {
            errorStates.add(EnumErrorCode.IS_RAINING);
        }
        if (world.func_72935_r()) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOT_NIGHT);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_DAY);
        }
        if (housing.getBlockLightValue() > 11) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOT_GLOOMY);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_BRIGHT);
        }
        if (!(world.func_230315_m_().func_236037_d_() || housing.canBlockSeeTheSky() || this.canWorkUnderground(beeModifier))) {
            errorStates.add(EnumErrorCode.NO_SKY);
        }
        IAlleleBeeSpecies species = this.genome.getActiveAllele(BeeChromosomes.SPECIES);
        EnumTemperature actualTemperature = housing.getTemperature();
        if (!AlleleManager.climateHelper.isWithinLimits(actualTemperature, beeBaseTemperature = species.getTemperature(), beeToleranceTemperature = this.genome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE))) {
            if (beeBaseTemperature.ordinal() > actualTemperature.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_COLD);
            } else {
                errorStates.add(EnumErrorCode.TOO_HOT);
            }
        }
        if (!AlleleManager.climateHelper.isWithinLimits(actualHumidity = housing.getHumidity(), beeBaseHumidity = species.getHumidity(), beeToleranceHumidity = this.genome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE))) {
            if (beeBaseHumidity.ordinal() > actualHumidity.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_ARID);
            } else {
                errorStates.add(EnumErrorCode.TOO_HUMID);
            }
        }
        return errorStates;
    }

    private boolean canWorkAtNight(IBeeModifier beeModifier) {
        return this.genome.getActiveAllele(BeeChromosomes.SPECIES).isNocturnal() || this.genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS) != false || beeModifier.isSelfLighted();
    }

    private boolean canWorkDuringDay() {
        return !this.genome.getActiveAllele(BeeChromosomes.SPECIES).isNocturnal() || this.genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS) != false;
    }

    private boolean canWorkUnderground(IBeeModifier beeModifier) {
        return this.genome.getActiveValue(BeeChromosomes.CAVE_DWELLING) != false || beeModifier.isSunlightSimulated();
    }

    private boolean canFlyInRain(IBeeModifier beeModifier) {
        return this.genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN) != false || beeModifier.isSealed();
    }

    private boolean isSuitableBiome(Biome biome) {
        EnumTemperature temperature = EnumTemperature.getFromBiome(biome);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
        return this.isSuitableClimate(temperature, humidity);
    }

    private boolean isSuitableClimate(EnumTemperature temperature, EnumHumidity humidity) {
        return AlleleManager.climateHelper.isWithinLimits(temperature, humidity, this.genome.getActiveAllele(BeeChromosomes.SPECIES).getTemperature(), this.genome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE), this.genome.getActiveAllele(BeeChromosomes.SPECIES).getHumidity(), this.genome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE));
    }

    @Override
    public List<ResourceLocation> getSuitableBiomes() {
        ArrayList<ResourceLocation> suitableBiomes = new ArrayList<ResourceLocation>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!this.isSuitableBiome(biome)) continue;
            suitableBiomes.add(biome.getRegistryName());
        }
        return suitableBiomes;
    }

    @Override
    public void addTooltip(List<ITextComponent> list) {
        ToolTip toolTip = new ToolTip();
        if (!this.isAnalyzed) {
            ((TextCompound)((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("<")).translated("for.gui.unknown", new Object[0])).text(">")).style(TextFormatting.GRAY)).create();
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getActiveAllele(BeeChromosomes.SPECIES);
        IAlleleBeeSpecies secondary = this.genome.getInactiveAllele(BeeChromosomes.SPECIES);
        if (!this.isPureBred(BeeChromosomes.SPECIES)) {
            ((TextCollection)toolTip.translated("for.bees.hybrid", primary.getDisplayName(), secondary.getDisplayName())).style(TextFormatting.BLUE);
        }
        if (this.generation > 0) {
            Rarity rarity = this.generation >= 1000 ? Rarity.EPIC : (this.generation >= 100 ? Rarity.RARE : (this.generation >= 10 ? Rarity.UNCOMMON : Rarity.COMMON));
            ((TextCollection)toolTip.translated("for.gui.beealyzer.generations", this.generation)).style(rarity.field_77937_e);
        }
        ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().add(this.genome.getActiveAllele(BeeChromosomes.LIFESPAN).getDisplayName()).text(" ")).translated("for.gui.life", new Object[0])).style(TextFormatting.GRAY)).create();
        IAlleleValue<Float> speedAllele = this.genome.getActiveAllele(BeeChromosomes.SPEED);
        TranslationTextComponent customSpeed = new TranslationTextComponent("for.tooltip.worker." + speedAllele.getLocalisationKey().replaceAll("(.*)\\.", ""));
        if (Translator.canTranslate(customSpeed)) {
            ((TextCompound)toolTip.singleLine().add((ITextComponent)customSpeed).style(TextFormatting.GRAY)).create();
        } else {
            ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().add(speedAllele.getDisplayName()).text(" ")).translated("for.gui.worker", new Object[0])).style(TextFormatting.GRAY)).create();
        }
        IAlleleValue<EnumTolerance> tempToleranceAllele = this.getGenome().getActiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE);
        IAlleleValue<EnumTolerance> humidToleranceAllele = this.getGenome().getActiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE);
        ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("T: ")).add(AlleleManager.climateHelper.toDisplay(primary.getTemperature())).text(" / ")).add(tempToleranceAllele.getDisplayName()).style(TextFormatting.GREEN)).create();
        ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("H: ")).add(AlleleManager.climateHelper.toDisplay(primary.getHumidity())).text(" / ")).add(humidToleranceAllele.getDisplayName()).style(TextFormatting.GREEN)).create();
        toolTip.add(this.genome.getActiveAllele(BeeChromosomes.FLOWER_PROVIDER).getProvider().getDescription(), TextFormatting.GRAY);
        if (this.genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS).booleanValue()) {
            ((TextCollection)toolTip.text(GenericRatings.rateActivityTime(true, false))).style(TextFormatting.RED);
        }
        if (this.genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN).booleanValue()) {
            ((TextCollection)toolTip.translated("for.gui.flyer.tooltip", new Object[0])).style(TextFormatting.WHITE);
        }
        list.addAll(toolTip.getLines());
    }

    @Override
    public void age(World world, float housingLifespanModifier) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        IBeeModifier beeModifier = mode.getBeeModifier();
        float finalModifier = housingLifespanModifier * beeModifier.getLifespanModifier(this.genome, this.mate, housingLifespanModifier);
        super.age(world, finalModifier);
    }

    @Override
    public NonNullList<ItemStack> getProduceList() {
        NonNullList products = NonNullList.func_191196_a();
        IAlleleBeeSpecies primary = this.genome.getActiveAllele(BeeChromosomes.SPECIES);
        IAlleleBeeSpecies secondary = this.genome.getInactiveAllele(BeeChromosomes.SPECIES);
        products.addAll(primary.getProducts().getPossibleStacks());
        NonNullList<ItemStack> secondaryProducts = secondary.getProducts().getPossibleStacks();
        for (ItemStack second : secondaryProducts) {
            boolean skip = false;
            for (ItemStack compare : products) {
                if (!second.func_77969_a(compare)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add((Object)second);
        }
        return products;
    }

    @Override
    public NonNullList<ItemStack> getSpecialtyList() {
        return this.genome.getActiveAllele(BeeChromosomes.SPECIES).getSpecialties().getPossibleStacks();
    }

    @Override
    public NonNullList<ItemStack> produceStacks(IBeeHousing housing) {
        World world = housing.getWorldObj();
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        NonNullList products = NonNullList.func_191196_a();
        IAlleleBeeSpecies primary = this.genome.getActiveAllele(BeeChromosomes.SPECIES);
        IAlleleBeeSpecies secondary = this.genome.getInactiveAllele(BeeChromosomes.SPECIES);
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = mode.getBeeModifier();
        float speed = this.genome.getActiveValue(BeeChromosomes.SPEED).floatValue() * beeHousingModifier.getProductionModifier(this.genome, 1.0f) * beeModeModifier.getProductionModifier(this.genome, 1.0f);
        primary.getProducts().addProducts((IBlockReader)world, housing.getCoordinates(), (NonNullList<ItemStack>)products, product -> Float.valueOf(product.getChance() * speed), world.field_73012_v);
        secondary.getProducts().addProducts((IBlockReader)world, housing.getCoordinates(), (NonNullList<ItemStack>)products, product -> Float.valueOf((float)Math.round(product.getChance() / 2.0f) * speed), world.field_73012_v);
        if (primary.isJubilant(this.genome, housing) && secondary.isJubilant(this.genome, housing)) {
            primary.getSpecialties().addProducts((IBlockReader)world, housing.getCoordinates(), (NonNullList<ItemStack>)products, product -> Float.valueOf(product.getChance() * speed), world.field_73012_v);
        }
        BlockPos housingCoordinates = housing.getCoordinates();
        return this.genome.getActiveAllele(BeeChromosomes.FLOWER_PROVIDER).getProvider().affectProducts(world, this, housingCoordinates, (NonNullList<ItemStack>)products);
    }

    @Override
    @Nullable
    public Optional<IBee> spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return Optional.empty();
        }
        if (BeeManager.beeRoot.getBeekeepingMode(housing.getWorldObj()).isFatigued(this, housing)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.createOffspring(housing, this.mate, this.getGeneration() + 1));
    }

    @Override
    public List<IBee> spawnDrones(IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (this.mate == null) {
            return Collections.emptyList();
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        BlockPos housingPos = housing.getCoordinates();
        int toCreate = BeeManager.beeRoot.getBeekeepingMode(world).getFinalFertility(this, world, housingPos);
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, this.mate, 0);
            offspring.setIsNatural(true);
            bees.add(offspring);
        }
        return bees;
    }

    private IBee createOffspring(IBeeHousing housing, IGenome mate, int generation) {
        IChromosome[] mutated2;
        World world = housing.getWorldObj();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = mate.getChromosomes();
        IChromosome[] mutated1 = Bee.mutateSpecies(housing, this.genome, mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Bee.mutateSpecies(housing, mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = parent1[i].inheritChromosome(world.field_73012_v, parent2[i]);
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        return new Bee(new Genome(BeeManager.beeRoot.getKaryotype(), chromosomes), null, mode.isNaturalOffspring(this), generation);
    }

    @Nullable
    private static IChromosome[] mutateSpecies(IBeeHousing housing, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAlleleBeeSpecies allele1;
        IAlleleBeeSpecies allele0;
        World world = housing.getWorldObj();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = (IAlleleBeeSpecies)parent1[BeeChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = (IAlleleBeeSpecies)parent2[BeeChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleBeeSpecies)parent2[BeeChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = (IAlleleBeeSpecies)parent1[BeeChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        GameProfile playerProfile = housing.getOwner();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker((IWorld)world, playerProfile);
        IMutationContainer container = (IMutationContainer)BeeManager.beeRoot.getComponent(ComponentKeys.MUTATIONS);
        List combinations = container.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            IBeeMutation beeMutation = (IBeeMutation)mutation;
            float chance = beeMutation.getChance(housing, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker.isResearched(beeMutation)) {
                float mutationBoost = chance * (Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            breedingTracker.registerMutation(mutation);
            return BeeManager.beeRoot.getKaryotype().templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    @Nullable
    public Optional<IIndividual> retrievePollen(IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getActiveValue(BeeChromosomes.FLOWERING).intValue() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return Optional.empty();
        }
        Vector3i area = Bee.getArea(this.genome, beeModifier);
        Vector3i offset = new Vector3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        IIndividual pollen = null;
        for (int i = 0; i < 20; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos blockPos = VectUtil.add(new Vector3i[]{housingPos, randomPos, offset});
            ICheckPollinatable pitcher = TileUtil.getTile((IBlockReader)world, blockPos, ICheckPollinatable.class);
            if (pitcher != null) {
                if (this.genome.getActiveAllele(BeeChromosomes.FLOWER_PROVIDER).getProvider().isAcceptedPollinatable(world, pitcher)) {
                    pollen = pitcher.getPollen();
                }
            } else {
                pollen = GeneticsUtil.getPollen((IWorld)world, blockPos).orElse(null);
            }
            if (pollen == null) continue;
            return Optional.of(pollen);
        }
        return Optional.empty();
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IIndividual pollen) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = (int)((float)this.genome.getActiveValue(BeeChromosomes.FLOWERING).intValue() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return false;
        }
        Vector3i area = Bee.getArea(this.genome, beeModifier);
        Vector3i offset = new Vector3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        for (int i = 0; i < 30; ++i) {
            IPollinatable realPollinatable;
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos posBlock = VectUtil.add(new Vector3i[]{housingPos, randomPos, offset});
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(world, posBlock);
            if (checkPollinatable == null || !this.genome.getActiveAllele(BeeChromosomes.FLOWER_PROVIDER).getProvider().isAcceptedPollinatable(world, checkPollinatable) || !checkPollinatable.canMateWith(pollen) || (realPollinatable = GeneticsUtil.getOrCreatePollinatable(housing.getOwner(), world, posBlock, Config.pollinateVanillaTrees)) == null) continue;
            realPollinatable.mateWith(pollen);
            return true;
        }
        return false;
    }

    @Override
    public Optional<BlockPos> plantFlowerRandom(IBeeHousing housing, List<BlockState> potentialFlowers) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getActiveValue(BeeChromosomes.FLOWERING).intValue() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return Optional.empty();
        }
        IFlowerProvider provider = this.genome.getActiveAllele(BeeChromosomes.FLOWER_PROVIDER).getProvider();
        Vector3i area = Bee.getArea(this.genome, beeModifier);
        Vector3i offset = new Vector3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos posBlock = VectUtil.add(new Vector3i[]{housingPos, randomPos, offset});
            if (!FlowerManager.flowerRegistry.growFlower(provider.getFlowerType(), world, this, posBlock, potentialFlowers)) continue;
            return Optional.of(posBlock);
        }
        return Optional.empty();
    }

    private static Vector3i getArea(IGenome genome, IBeeModifier beeModifier) {
        Vector3i genomeTerritory = genome.getActiveValue(BeeChromosomes.TERRITORY);
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
    }
}

