/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.render.ParticleRender;
import genetics.api.individual.IGenome;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlleleEffectPotion
extends AlleleEffectThrottled {
    private final Effect potion;
    private final int potionFXColor;
    private final int duration;
    private final float chance;

    public AlleleEffectPotion(String name, boolean isDominant, Effect potion, int duration, int throttle, float chance) {
        super(name, isDominant, throttle, true, false);
        this.potion = potion;
        this.duration = duration;
        this.chance = chance;
        Set<EffectInstance> potionEffects = Collections.singleton(new EffectInstance(potion, 1, 0));
        this.potionFXColor = PotionUtils.func_185181_a(potionEffects);
    }

    public AlleleEffectPotion(String name, boolean isDominant, Effect potion, int duration) {
        this(name, isDominant, potion, duration, 200, 1.0f);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        List<LivingEntity> entities = AlleleEffectPotion.getEntitiesInRange(genome, housing, LivingEntity.class);
        for (LivingEntity entity : entities) {
            if (world.field_73012_v.nextFloat() >= this.chance) continue;
            int dur = this.duration;
            if (this.potion.func_220303_e() == EffectType.HARMFUL) {
                int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getRegistryName(), true);
                if (count >= 4) continue;
                if (count == 3) {
                    dur = this.duration / 4;
                } else if (count == 2) {
                    dur = this.duration / 2;
                } else if (count == 1) {
                    dur = this.duration * 3 / 4;
                }
            } else if (entity instanceof IMob) continue;
            entity.func_195064_c(new EffectInstance(this.potion, dur, 0));
        }
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (world.field_73012_v.nextBoolean()) {
            super.doFX(genome, storedData, housing);
        } else {
            Vector3d beeFXCoordinates = housing.getBeeFXCoordinates();
            ParticleRender.addEntityPotionFX(world, beeFXCoordinates.field_72450_a, beeFXCoordinates.field_72448_b + 0.5, beeFXCoordinates.field_72449_c, this.potionFXColor);
        }
        return storedData;
    }
}

