/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.ApicultureCapabilities;
import forestry.api.arboriculture.ArboricultureCapabilities;
import forestry.api.core.ItemGroups;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.features.CoreItems;
import forestry.core.items.definitions.EnumCraftingMaterial;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ItemArmorApiarist
extends ArmorItem {
    public ItemArmorApiarist(EquipmentSlotType equipmentSlotIn) {
        super((IArmorMaterial)new ApiaristArmorMaterial(), equipmentSlotIn, new Item.Properties().func_200916_a(ItemGroups.tabApiculture));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (ApicultureItems.APIARIST_LEGS.itemEqual(stack)) {
            return "forestry:textures/item/apiarist_armor_2.png";
        }
        return "forestry:textures/item/apiarist_armor_1.png";
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                if (capability == ApicultureCapabilities.ARMOR_APIARIST) {
                    return LazyOptional.of(() -> capability.getDefaultInstance());
                }
                if (capability == ArboricultureCapabilities.ARMOR_NATURALIST && ItemArmorApiarist.this.field_77881_a == EquipmentSlotType.HEAD) {
                    return LazyOptional.of(() -> capability.getDefaultInstance());
                }
                return LazyOptional.empty();
            }
        };
    }

    public static final class ApiaristArmorMaterial
    implements IArmorMaterial {
        private static final int[] reductions = new int[]{1, 2, 3, 1};

        public int func_200896_a(EquipmentSlotType slotIn) {
            return 5;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return reductions[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return 15;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.WOVEN_SILK, 1)});
        }

        public String func_200897_d() {
            return "APIARIST_ARMOR";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    }
}

