/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.api.core.ItemGroups;
import forestry.core.items.ItemForestry;
import genetics.api.individual.IGenome;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemHiveFrame
extends ItemForestry
implements IHiveFrame {
    private final HiveFrameBeeModifier beeModifier;

    public ItemHiveFrame(int maxDamage, float geneticDecay) {
        super(new Item.Properties().func_200918_c(maxDamage).func_200916_a(ItemGroups.tabApiculture));
        this.beeModifier = new HiveFrameBeeModifier(geneticDecay);
    }

    @Override
    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        if (frame.func_96631_a(wear, field_77697_d, null)) {
            return ItemStack.field_190927_a;
        }
        return frame;
    }

    @Override
    public IBeeModifier getBeeModifier(ItemStack frame) {
        return this.beeModifier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        this.beeModifier.addInformation(stack, world, tooltip, advanced);
        if (!stack.func_77951_h()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.forestry.durability", new Object[]{stack.func_77958_k()}));
        }
    }

    private static class HiveFrameBeeModifier
    extends DefaultBeeModifier {
        private static final float production = 2.0f;
        private final float geneticDecay;

        public HiveFrameBeeModifier(float geneticDecay) {
            this.geneticDecay = geneticDecay;
        }

        @Override
        public float getProductionModifier(IGenome genome, float currentModifier) {
            return currentModifier < 10.0f ? 2.0f : 1.0f;
        }

        @Override
        public float getGeneticDecay(IGenome genome, float currentModifier) {
            return this.geneticDecay;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void addInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.forestry.bee.modifier.production", new Object[]{Float.valueOf(2.0f)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.forestry.bee.modifier.genetic.decay", new Object[]{Float.valueOf(this.geneticDecay)}));
        }
    }
}

