/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.network.PacketBufferForestry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileApiary
extends TileBeeHousingBase
implements IApiary {
    private final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final InventoryApiary inventory = new InventoryApiary();

    public TileApiary() {
        super(ApicultureTiles.APIARY.tileType(), "apiary");
        this.setInternalInventory(this.inventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (Tuple<IHiveFrame, ItemStack> frame : this.inventory.getFrames()) {
            IHiveFrame hiveFrame = (IHiveFrame)frame.func_76341_a();
            ItemStack stack = (ItemStack)frame.func_76340_b();
            IBeeModifier beeModifier = hiveFrame.getBeeModifier(stack);
            beeModifiers.add(beeModifier);
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerBeeHousing(windowId, player.field_71071_by, this, true, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            PacketBufferForestry forestryP = new PacketBufferForestry((ByteBuf)p);
            forestryP.func_179255_a(pos);
            forestryP.writeBoolean(true);
            forestryP.writeEnum(GuiBeeHousing.Icon.APIARY, GuiBeeHousing.Icon.values());
        });
    }
}

