/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.apiculture.BeehouseBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.network.PacketBufferForestry;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileBeeHouse
extends TileBeeHousingBase {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private final IBeeListener beeListener = new DefaultBeeListener();
    private final InventoryBeeHousing beeInventory = new InventoryBeeHousing(12);

    public TileBeeHouse() {
        super(ApicultureTiles.BEE_HOUSE.tileType(), "bee.house");
        this.beeInventory.disableAutomation();
        this.setInternalInventory(this.beeInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerBeeHousing(windowId, player.field_71071_by, this, false, GuiBeeHousing.Icon.BEE_HOUSE);
    }

    @Override
    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            PacketBufferForestry forestryP = new PacketBufferForestry((ByteBuf)p);
            forestryP.func_179255_a(pos);
            forestryP.writeBoolean(false);
            forestryP.writeEnum(GuiBeeHousing.Icon.BEE_HOUSE, GuiBeeHousing.Icon.values());
        });
    }
}

