/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.apiculture.features.ApicultureTiles;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCandle
extends TileEntity {
    private int colour;
    private boolean lit;

    public TileCandle() {
        super(ApicultureTiles.CANDLE.tileType());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        return this.func_189515_b(tag);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.func_230337_a_(state, tag);
    }

    public void onPacketUpdate(int colour, boolean isLit) {
        this.colour = colour;
        this.lit = isLit;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagRoot) {
        super.func_230337_a_(state, tagRoot);
        this.colour = tagRoot.func_74762_e("colour");
        this.lit = tagRoot.func_74767_n("lit");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagRoot) {
        tagRoot = super.func_189515_b(tagRoot);
        tagRoot.func_74768_a("colour", this.colour);
        tagRoot.func_74757_a("lit", this.lit);
        return tagRoot;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int value) {
        this.colour = value;
    }

    public void addColour(int colour2) {
        int[] myColour = TileCandle.fromIntColour(this.colour);
        int[] addColour = TileCandle.fromIntColour(colour2);
        this.colour = TileCandle.toIntColour((addColour[0] + myColour[0]) / 2, (addColour[1] + myColour[1]) / 2, (addColour[2] + myColour[2]) / 2);
    }

    private static int[] fromIntColour(int value) {
        int[] cs = new int[]{(value & 0xFF0000) >> 16, (value & 0xFF00) >> 8, value & 0xFF};
        return cs;
    }

    private static int toIntColour(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }
}

