/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveDrop;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.HiveConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;

public final class Hive {
    private final IHiveDescription hiveDescription;
    private final List<IHiveDrop> drops = new ArrayList<IHiveDrop>();

    public Hive(IHiveDescription hiveDescription) {
        this.hiveDescription = hiveDescription;
    }

    public BlockState getHiveBlockState() {
        return this.hiveDescription.getBlockState();
    }

    public void addDrops(List<IHiveDrop> drops) {
        this.drops.addAll(drops);
    }

    public List<IHiveDrop> getDrops() {
        return this.drops;
    }

    public float genChance() {
        return this.hiveDescription.getGenChance();
    }

    public void postGen(ISeedReader world, Random rand, BlockPos pos) {
        this.hiveDescription.postGen(world, rand, pos);
    }

    public boolean isGoodBiome(Biome biome) {
        return this.hiveDescription.isGoodBiome(biome);
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        return this.hiveDescription.isGoodHumidity(humidity);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        return this.hiveDescription.isGoodTemperature(temperature);
    }

    public boolean isValidLocation(ISeedReader world, BlockPos pos) {
        if (!HiveConfig.isDimAllowed(world.func_201672_e().func_234923_W_().func_240901_a_())) {
            return false;
        }
        return this.hiveDescription.getHiveGen().isValidLocation(world, pos);
    }

    public boolean canReplace(ISeedReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return this.hiveDescription.getHiveGen().canReplace(blockState, world, pos);
    }

    @Nullable
    public BlockPos getPosForHive(ISeedReader world, int x, int z) {
        return this.hiveDescription.getHiveGen().getPosForHive(world, x, z);
    }

    public String toString() {
        return this.hiveDescription + " hive";
    }
}

