/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.worldgen.Hive;
import forestry.core.config.Config;
import forestry.core.utils.Log;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HiveDecorator
extends Feature<NoFeatureConfig> {
    public HiveDecorator() {
        super(NoFeatureConfig.field_236558_a_);
    }

    private static boolean decorateHivesDebug(ISeedReader world, Random rand, BlockPos pos, List<Hive> hives) {
        int posX = pos.func_177958_n() + rand.nextInt(16);
        int posZ = pos.func_177952_p() + rand.nextInt(16);
        Biome biome = world.func_226691_t_(new BlockPos(posX, 0, posZ));
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Collections.shuffle(hives, rand);
                for (Hive hive : hives) {
                    if (!hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity)) continue;
                    return HiveDecorator.tryGenHive(world, rand, posX + x, posZ + z, hive);
                }
            }
        }
        return false;
    }

    public static boolean tryGenHive(ISeedReader world, Random rand, int x, int z, Hive hive) {
        BlockPos hivePos = hive.getPosForHive(world, x, z);
        if (hivePos == null) {
            return false;
        }
        if (!hive.canReplace(world, hivePos)) {
            return false;
        }
        Biome biome = world.func_226691_t_(hivePos);
        EnumTemperature temperature = EnumTemperature.getFromValue(biome.func_225486_c(hivePos));
        if (!hive.isGoodTemperature(temperature)) {
            return false;
        }
        if (!hive.isValidLocation(world, hivePos)) {
            return false;
        }
        return HiveDecorator.setHive(world, rand, hivePos, hive);
    }

    private static boolean setHive(ISeedReader world, Random rand, BlockPos pos, Hive hive) {
        BlockState hiveState = hive.getHiveBlockState();
        Block hiveBlock = hiveState.func_177230_c();
        boolean placed = world.func_180501_a(pos, hiveState, 2);
        if (!placed) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block placedBlock = state.func_177230_c();
        if (hiveBlock != placedBlock) {
            return false;
        }
        hiveBlock.func_220082_b(state, (World)world.func_201672_e(), pos, hiveState, false);
        if (!Config.generateBeehivesDebug) {
            hive.postGen(world, rand, pos);
        }
        if (Config.logHivePlacement) {
            Log.info("Placed {} at {}", hive.toString(), pos.func_229422_x_());
        }
        return true;
    }

    public boolean place(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        List<Hive> hives = ModuleApiculture.getHiveRegistry().getHives();
        if (Config.generateBeehivesDebug) {
            HiveDecorator.decorateHivesDebug(seedReader, rand, pos, hives);
            return false;
        }
        Collections.shuffle(hives, rand);
        for (int tries = 0; tries < hives.size() / 2; ++tries) {
            Biome biome = seedReader.func_226691_t_(pos);
            EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
            for (Hive hive : hives) {
                int z;
                int x;
                if (!((double)hive.genChance() * Config.getBeehivesAmount() * (double)hives.size() / 8.0 >= (double)(rand.nextFloat() * 100.0f)) || !hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity) || !HiveDecorator.tryGenHive(seedReader, rand, x = pos.func_177958_n() + rand.nextInt(16), z = pos.func_177952_p() + rand.nextInt(16), hive)) continue;
                return true;
            }
        }
        return false;
    }
}

