/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.EmptyProductList;
import forestry.api.genetics.products.IProductList;
import genetics.api.individual.IGenome;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public class FruitProviderNone
implements IFruitProvider {
    private static final HashMap<String, OverlayType> overlayTypes = new HashMap();
    private final String unlocalizedDescription;
    private final IFruitFamily family;
    protected int ripeningPeriod = 10;
    @Nullable
    private OverlayType overlay = null;

    public FruitProviderNone(String unlocalizedDescription, IFruitFamily family) {
        this.unlocalizedDescription = unlocalizedDescription;
        this.family = family;
    }

    public IFruitProvider setOverlay(String ident) {
        this.overlay = overlayTypes.get(ident);
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    @Override
    public NonNullList<ItemStack> getFruits(IGenome genome, World world, BlockPos pos, int ripeningTime) {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean requiresFruitBlocks() {
        return false;
    }

    @Override
    public boolean trySpawnFruitBlock(IGenome genome, IWorld world, Random rand, BlockPos pos) {
        return false;
    }

    @Override
    public int getColour(IGenome genome, IBlockReader world, BlockPos pos, int ripeningTime) {
        return 0xFFFFFF;
    }

    @Override
    public int getDecorativeColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean isFruitLeaf(IGenome genome, IWorld world, BlockPos pos) {
        return false;
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    @Override
    public IProductList getProducts() {
        return EmptyProductList.INSTANCE;
    }

    @Override
    public IProductList getSpecialty() {
        return EmptyProductList.INSTANCE;
    }

    @Override
    public TextComponent getDescription() {
        return new TranslationTextComponent(this.unlocalizedDescription);
    }

    @Override
    public ResourceLocation getSprite(IGenome genome, IBlockReader world, BlockPos pos, int ripeningTime) {
        if (this.overlay != null) {
            return this.overlay.sprite;
        }
        return null;
    }

    @Override
    public ResourceLocation getDecorativeSprite() {
        if (this.overlay != null) {
            return this.overlay.sprite;
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        if (this.overlay != null) {
            event.addSprite(this.overlay.sprite);
        }
    }

    @Override
    @Nullable
    public String getModelName() {
        return null;
    }

    @Override
    public String getModID() {
        return "forestry";
    }

    static {
        overlayTypes.put("berries", new OverlayType("berries"));
        overlayTypes.put("pomes", new OverlayType("pomes"));
        overlayTypes.put("nuts", new OverlayType("nuts"));
        overlayTypes.put("citrus", new OverlayType("citrus"));
        overlayTypes.put("plums", new OverlayType("plums"));
    }

    private static class OverlayType {
        public final String ident;
        public final ResourceLocation sprite;

        public OverlayType(String ident) {
            this.ident = ident;
            this.sprite = new ResourceLocation("forestry", "block/leaves/fruits." + ident);
        }
    }
}

