/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockFruitPod
extends CocoaBlock {
    private final IAlleleFruit fruit;

    public static List<BlockFruitPod> create() {
        ArrayList<BlockFruitPod> blocks = new ArrayList<BlockFruitPod>();
        for (IAlleleFruit fruit : AlleleFruits.getFruitAllelesWithModels()) {
            BlockFruitPod block = new BlockFruitPod(fruit);
            blocks.add(block);
        }
        return blocks;
    }

    public BlockFruitPod(IAlleleFruit fruit) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_200948_a(0.2f, 3.0f).func_200947_a(SoundType.field_185848_a));
        this.fruit = fruit;
    }

    public IAlleleFruit getFruit() {
        return this.fruit;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileFruitPod tile = TileUtil.getTile(world, pos, TileFruitPod.class);
        if (tile == null) {
            return ItemStack.field_190927_a;
        }
        return tile.getPickBlock();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            BlockFruitPod.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return;
        }
        TileFruitPod tile = TileUtil.getTile((IBlockReader)world, pos, TileFruitPod.class);
        if (tile == null) {
            return;
        }
        tile.onBlockTick((World)world, pos, state, rand);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileFruitPod tile;
        if (!world.field_72995_K && (tile = TileUtil.getTile((IBlockReader)world, pos, TileFruitPod.class)) != null) {
            for (ItemStack drop : tile.getDrops()) {
                ItemStackUtil.dropItemStackAsEntity(drop, world, pos);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
        return BlockUtil.isValidPodLocation(world, pos, facing, this.fruit.getProvider().getLogTag());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileFruitPod();
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        TileFruitPod podTile = TileUtil.getTile(world, pos, TileFruitPod.class);
        return podTile != null && podTile.canMature();
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        TileFruitPod podTile = TileUtil.getTile((IBlockReader)world, pos, TileFruitPod.class);
        if (podTile != null) {
            podTile.addRipeness(0.5f);
        }
    }
}

