/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.commands.ITreeSpawner;
import forestry.arboriculture.genetics.TreeDefinition;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IIndividual;
import genetics.commands.PermLevel;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public final class CommandTreeSpawn {
    public static ArgumentBuilder<CommandSource, ?> register(String name, ITreeSpawner treeSpawner) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires((Predicate)PermLevel.ADMIN)).then(Commands.func_197056_a((String)"type", (ArgumentType)TreeArugment.treeArgument()).executes(a -> CommandTreeSpawn.run(treeSpawner, (CommandSource)a.getSource(), (ITree)a.getArgument("type", ITree.class))))).executes(a -> CommandTreeSpawn.run(treeSpawner, (CommandSource)a.getSource(), TreeDefinition.Oak.createIndividual()));
    }

    public static int run(ITreeSpawner treeSpawner, CommandSource source, ITree tree) throws CommandSyntaxException {
        return treeSpawner.spawn(source, tree, (PlayerEntity)source.func_197035_h());
    }

    public static class TreeArugment
    implements ArgumentType<ITree> {
        public static TreeArugment treeArgument() {
            return new TreeArugment();
        }

        public ITree parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
            return (ITree)TreeManager.treeRoot.templateAsIndividual(TreeManager.treeRoot.getTemplate(location.toString()));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(TreeManager.treeRoot.getIndividualTemplates().stream().map(IIndividual::getGenome).map(a -> a.getActiveAllele(TreeChromosomes.SPECIES)).map(IAllele::getRegistryName).map(ResourceLocation::toString), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return TreeManager.treeRoot.getIndividualTemplates().stream().map(IIndividual::getGenome).map(a -> a.getActiveAllele(TreeChromosomes.SPECIES)).map(IAllele::getRegistryName).map(ResourceLocation::toString).collect(Collectors.toList());
        }
    }
}

