/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleLeafEffect;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeMutation;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import forestry.arboriculture.genetics.TreeGrowthHelper;
import forestry.core.config.Config;
import forestry.core.genetics.TemplateMatcher;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeMatcher;
import genetics.api.individual.Individual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.components.ComponentKeys;
import genetics.individual.Genome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class Tree
extends Individual
implements ITree,
IPlantable {
    private final IGenomeMatcher matcher;

    public Tree(IGenome genome) {
        super(genome);
        this.matcher = new TemplateMatcher(genome);
    }

    public Tree(IGenome genome, IGenome mate) {
        super(genome, mate);
        this.matcher = new TemplateMatcher(genome);
    }

    public Tree(CompoundNBT compoundNBT) {
        super(compoundNBT);
        this.matcher = new TemplateMatcher(this.genome);
    }

    @Override
    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public boolean matchesTemplateGenome() {
        return this.matcher.matches();
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, World world, BlockPos pos) {
        IAlleleLeafEffect effect = this.getGenome().getActiveAllele(TreeChromosomes.EFFECT);
        storedData[0] = this.doEffect(effect, storedData[0], world, pos);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleLeafEffect secondary = this.getGenome().getInactiveAllele(TreeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, pos);
        return storedData;
    }

    private IEffectData doEffect(IAlleleLeafEffect effect, IEffectData storedData, World world, BlockPos pos) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData[] doFX(IEffectData[] storedData, World world, BlockPos pos) {
        return storedData;
    }

    @Override
    public Feature<NoFeatureConfig> getTreeGenerator(ISeedReader world, BlockPos pos, boolean wasBonemealed) {
        return this.genome.getActiveAllele(TreeChromosomes.SPECIES).getGenerator().getTreeFeature(this);
    }

    @Override
    public boolean canStay(IBlockReader world, BlockPos pos) {
        BlockPos blockPos = pos.func_177977_b();
        BlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        return block.canSustainPlant(blockState, world, blockPos, Direction.UP, (IPlantable)this);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return this.genome.getActiveAllele(TreeChromosomes.SPECIES).getPlantType();
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    @Override
    @Nullable
    public BlockPos canGrow(IWorld world, BlockPos pos, int expectedGirth, int expectedHeight) {
        return TreeGrowthHelper.canGrow(world, this.genome, pos, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getActiveValue(TreeChromosomes.MATURATION);
    }

    @Override
    public int getGirth() {
        return this.genome.getActiveValue(TreeChromosomes.GIRTH);
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getActiveValue(TreeChromosomes.FERTILITY).floatValue() * this.getGenome().getActiveValue(TreeChromosomes.SAPPINESS).floatValue() * 100.0f);
        return Math.max(base, 1) * 10;
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getActiveValue(TreeChromosomes.HEIGHT).floatValue();
    }

    @Override
    public boolean setLeaves(IWorld world, @Nullable GameProfile owner, BlockPos pos, Random rand) {
        return this.genome.getActiveAllele(TreeChromosomes.SPECIES).getGenerator().setLeaves(this.genome, world, owner, pos, rand);
    }

    @Override
    public boolean setLogBlock(IWorld world, BlockPos pos, Direction facing) {
        return this.genome.getActiveAllele(TreeChromosomes.SPECIES).getGenerator().setLogBlock(this.genome, world, pos, facing);
    }

    @Override
    public boolean allowsFruitBlocks() {
        IFruitProvider provider = this.getGenome().getActiveAllele(TreeChromosomes.FRUITS).getProvider();
        if (!provider.requiresFruitBlocks()) {
            return false;
        }
        Collection<IFruitFamily> suitable = this.genome.getActiveAllele(TreeChromosomes.SPECIES).getSuitableFruit();
        return suitable.contains(provider.getFamily());
    }

    @Override
    public boolean trySpawnFruitBlock(IWorld world, Random rand, BlockPos pos) {
        IFruitProvider provider = this.getGenome().getActiveAllele(TreeChromosomes.FRUITS).getProvider();
        Collection<IFruitFamily> suitable = this.genome.getActiveAllele(TreeChromosomes.SPECIES).getSuitableFruit();
        return suitable.contains(provider.getFamily()) && provider.trySpawnFruitBlock(this.getGenome(), world, rand, pos);
    }

    @Override
    public IGenome getGenome() {
        return this.genome;
    }

    @Override
    public ITree copy() {
        CompoundNBT compound = new CompoundNBT();
        this.write(compound);
        return new Tree(compound);
    }

    @Override
    public boolean isPureBred(IChromosomeType chromosome) {
        return this.genome.getActiveAllele(chromosome).getRegistryName().equals((Object)this.genome.getInactiveAllele(chromosome).getRegistryName());
    }

    @Override
    public void addTooltip(List<ITextComponent> list) {
    }

    @Override
    public List<ITree> getSaplings(World world, @Nullable GameProfile playerProfile, BlockPos pos, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getActiveValue(TreeChromosomes.FERTILITY).floatValue() * modifier;
        if (world.field_73012_v.nextFloat() <= chance) {
            if (this.mate == null) {
                prod.add(TreeManager.treeRoot.getTree(world, new Genome(TreeManager.treeRoot.getKaryotype(), this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, this.mate, playerProfile, pos));
            }
        }
        return prod;
    }

    private ITree createOffspring(World world, IGenome mate, @Nullable GameProfile playerProfile, BlockPos pos) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = mate.getChromosomes();
        IChromosome[] mutated = Tree.mutateSpecies(world, playerProfile, pos, this.genome, mate);
        if (mutated == null) {
            mutated = Tree.mutateSpecies(world, playerProfile, pos, mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(new Genome(TreeManager.treeRoot.getKaryotype(), mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = parent1[i].inheritChromosome(world.field_73012_v, parent2[i]);
        }
        return new Tree(new Genome(TreeManager.treeRoot.getKaryotype(), chromosomes));
    }

    @Nullable
    private static IChromosome[] mutateSpecies(World world, @Nullable GameProfile playerProfile, BlockPos pos, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAlleleTreeSpecies allele1;
        IAlleleTreeSpecies allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = (IAlleleTreeSpecies)parent1[TreeChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = (IAlleleTreeSpecies)parent2[TreeChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleTreeSpecies)parent2[TreeChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = (IAlleleTreeSpecies)parent1[TreeChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        IArboristTracker breedingTracker = null;
        if (playerProfile != null) {
            breedingTracker = TreeManager.treeRoot.getBreedingTracker((IWorld)world, playerProfile);
        }
        IMutationContainer container = (IMutationContainer)TreeManager.treeRoot.getComponent(ComponentKeys.MUTATIONS);
        List combinations = container.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            ITreeMutation treeMutation = (ITreeMutation)mutation;
            float chance = treeMutation.getChance(world, pos, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker != null && breedingTracker.isResearched(treeMutation)) {
                float mutationBoost = chance * (Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            return TreeManager.treeRoot.getKaryotype().templateAsChromosomes(treeMutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getActiveAllele(TreeChromosomes.SPECIES).getSuitableFruit().contains(this.genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getFamily());
    }

    @Override
    public IProductList getProducts() {
        return this.genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getProducts();
    }

    @Override
    public IProductList getSpecialties() {
        return this.genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getSpecialty();
    }

    @Override
    public NonNullList<ItemStack> produceStacks(World world, BlockPos pos, int ripeningTime) {
        return this.genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getFruits(this.genome, world, pos, ripeningTime);
    }
}

