/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.TextCompound;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.alyzer.IAlleleDisplayHandler;
import forestry.api.genetics.alyzer.IAlleleDisplayHelper;
import forestry.api.genetics.alyzer.IAlyzerHelper;
import forestry.apiculture.genetics.IGeneticTooltipProvider;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeValue;
import genetics.api.individual.IGenome;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum TreeDisplayHandler implements IAlleleDisplayHandler<ITree>
{
    SAPPINESS(TreeChromosomes.SAPPINESS, TextFormatting.GOLD, "S: %1$s"),
    MATURATION(TreeChromosomes.MATURATION, TextFormatting.RED, "M: %1$s"),
    GROUP_0(0, 0, 1),
    HEIGHT(TreeChromosomes.HEIGHT, TextFormatting.LIGHT_PURPLE, "H: %1$s"),
    GIRTH(TreeChromosomes.GIRTH, TextFormatting.AQUA, "G: %1$sx%2$s"),
    GROUP_1(1, 3, 4),
    SAPLINGS(TreeChromosomes.FERTILITY, TextFormatting.YELLOW, "S: %1$s"),
    YIELD(TreeChromosomes.YIELD, TextFormatting.WHITE, "Y: %1$s"),
    GROUP_2(2, 6, 7),
    FIREPROOF(TreeChromosomes.FIREPROOF, 3){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, ITree individual) {
            Boolean value = (Boolean)this.getActiveValue(genome);
            if (!value.booleanValue()) {
                return;
            }
            ((TextCollection)toolTip.translated("for.gui.fireresist", new Object[0])).style(TextFormatting.RED);
        }
    }
    ,
    FRUITS(TreeChromosomes.FRUITS, 4){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, ITree individual) {
            Object fruit = this.getActiveAllele(genome);
            if (fruit != AlleleFruits.fruitNone) {
                Object instance = ((TextCompound)toolTip.singleLine().text("F: ")).add((ITextComponent)genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getDescription()).style(TextFormatting.GREEN);
                if (!individual.canBearFruit()) {
                    instance.style(TextFormatting.STRIKETHROUGH);
                }
                instance.create();
            }
        }
    };

    final IChromosomeType type;
    @Nullable
    final String alyzerCaption;
    final int alyzerIndex;
    final int tooltipIndex;
    @Nullable
    final TextFormatting color;
    final String formattingText;
    final int[] groupPair;

    private TreeDisplayHandler(int tooltipIndex, int ... groupPair) {
        this.type = null;
        this.alyzerCaption = "";
        this.alyzerIndex = -1;
        this.tooltipIndex = tooltipIndex;
        this.color = null;
        this.formattingText = "";
        this.groupPair = groupPair;
    }

    private TreeDisplayHandler(IChromosomeType type, int alyzerIndex, int tooltipIndex) {
        this(type, alyzerIndex, tooltipIndex, null);
    }

    private TreeDisplayHandler(@Nullable IChromosomeType type, int alyzerIndex, String alyzerCaption) {
        this(type, alyzerIndex, -1, alyzerCaption);
    }

    private TreeDisplayHandler(IChromosomeType type, TextFormatting color, String formattingText) {
        this.type = type;
        this.alyzerCaption = "";
        this.alyzerIndex = -1;
        this.tooltipIndex = -1;
        this.color = color;
        this.formattingText = formattingText;
        this.groupPair = new int[0];
    }

    private TreeDisplayHandler(IChromosomeType type, int tooltipIndex) {
        this.type = type;
        this.alyzerCaption = "";
        this.alyzerIndex = -1;
        this.tooltipIndex = tooltipIndex;
        this.color = null;
        this.formattingText = "";
        this.groupPair = new int[0];
    }

    private TreeDisplayHandler(IChromosomeType type, @Nullable int alyzerIndex, int tooltipIndex, String alyzerCaption) {
        this.type = type;
        this.alyzerCaption = alyzerCaption;
        this.alyzerIndex = alyzerIndex;
        this.tooltipIndex = tooltipIndex;
        this.color = null;
        this.formattingText = "";
        this.groupPair = new int[0];
    }

    public static void init(IAlleleDisplayHelper helper) {
        for (TreeDisplayHandler handler : TreeDisplayHandler.values()) {
            int alyzerIndex;
            int tooltipIndex = handler.tooltipIndex;
            if (tooltipIndex >= 0) {
                helper.addTooltip(handler, "rootTrees", tooltipIndex * 10);
            }
            if ((alyzerIndex = handler.alyzerIndex) < 0) continue;
            helper.addAlyzer(handler, "rootTrees", alyzerIndex * 10);
        }
    }

    @Override
    public void addTooltip(ToolTip toolTip, IGenome genome, ITree individual) {
        if (this.groupPair.length == 2) {
            TreeDisplayHandler first = TreeDisplayHandler.values()[this.groupPair[0]];
            TreeDisplayHandler second = TreeDisplayHandler.values()[this.groupPair[1]];
            Object firstValue = genome.getActiveValue(first.type, Object.class);
            Object secondValue = genome.getActiveValue(second.type, Object.class);
            ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().add((ITextComponent)new TranslationTextComponent(first.formattingText, new Object[]{firstValue}), first.color)).text(" ")).add((ITextComponent)new TranslationTextComponent(second.formattingText, new Object[]{secondValue}), second.color)).create();
        }
    }

    @Override
    public void drawAlyzer(IAlyzerHelper helper, IGenome genome, double mouseX, double mouseY, MatrixStack transform) {
    }

    <V> IAlleleValue<V> getActive(IGenome genome) {
        return genome.getActiveAllele((IChromosomeValue)this.type);
    }

    <V> IAlleleValue<V> getInactive(IGenome genome) {
        return genome.getInactiveAllele((IChromosomeValue)this.type);
    }

    <A extends IAllele> A getActiveAllele(IGenome genome) {
        return genome.getActiveAllele((IChromosomeAllele)this.type);
    }

    <A extends IAllele> A getInactiveAllele(IGenome genome) {
        return genome.getInactiveAllele((IChromosomeAllele)this.type);
    }

    <V> V getActiveValue(IGenome genome) {
        return genome.getActiveValue((IChromosomeValue)this.type);
    }

    <V> V getInactiveValue(IGenome genome) {
        return genome.getInactiveValue((IChromosomeValue)this.type);
    }

    private static class AllelePair
    implements IGeneticTooltipProvider<ITree> {
        private final IGeneticTooltipProvider<ITree> first;
        private final IGeneticTooltipProvider<ITree> second;

        private AllelePair(IGeneticTooltipProvider<ITree> first, IGeneticTooltipProvider<ITree> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, ITree individual) {
            ToolTip cache = new ToolTip();
            this.first.addTooltip(cache, genome, individual);
            ITextComponent fistComp = cache.lastComponent();
            this.second.addTooltip(cache, genome, individual);
            ITextComponent secondComp = cache.lastComponent();
            toolTip.translated("%1$s %2$s", fistComp, secondComp);
        }
    }
}

