/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ILeafProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.genetics.ClimateGrowthProvider;
import forestry.core.genetics.alleles.AlleleForestrySpecies;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.PlantType;

public class AlleleTreeSpecies
extends AlleleForestrySpecies
implements IAlleleTreeSpecies {
    private final ITreeGenerator generator;
    private final IGermlingModelProvider germlingModelProvider;
    private final ILeafSpriteProvider leafSpriteProvider;
    private final ImmutableList<IFruitFamily> fruits;
    private final PlantType nativeType;
    private final ILeafProvider leafProvider;
    private final IGrowthProvider growthProvider;
    private final float rarity;

    public AlleleTreeSpecies(Builder builder) {
        super(builder);
        this.generator = builder.generator;
        this.germlingModelProvider = builder.germlingModelProvider;
        this.leafSpriteProvider = builder.leafSpriteProvider;
        this.nativeType = builder.nativeType;
        this.fruits = builder.fruits.build();
        this.rarity = builder.rarity;
        this.growthProvider = builder.growthProvider;
        this.leafProvider = builder.leafProvider != null ? (ILeafProvider)builder.leafProvider.apply(this) : null;
    }

    @Override
    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public IGrowthProvider getGrowthProvider() {
        return this.growthProvider;
    }

    @Override
    public PlantType getPlantType() {
        return this.nativeType;
    }

    public List<IFruitFamily> getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public ITreeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public ILeafSpriteProvider getLeafSpriteProvider() {
        return this.leafSpriteProvider;
    }

    @Override
    public int getSpriteColour(int renderPass) {
        return this.leafSpriteProvider.getColor(false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation getItemModel() {
        return new ModelResourceLocation(this.germlingModelProvider.getItemModel(), "inventory");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBlockModel() {
        return this.germlingModelProvider.getBlockModel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        return this.germlingModelProvider.getSpriteColor(type, renderPass);
    }

    @Override
    public Optional<ILeafProvider> getLeafProvider() {
        return Optional.of(this.leafProvider);
    }

    @Override
    public int compareTo(IAlleleTreeSpecies o) {
        return 0;
    }

    public static class Builder
    extends AlleleForestrySpecies.AbstractBuilder<IAlleleTreeSpeciesBuilder>
    implements IAlleleTreeSpeciesBuilder {
        private final ImmutableList.Builder<IFruitFamily> fruits = new ImmutableList.Builder();
        private ITreeGenerator generator;
        private IGermlingModelProvider germlingModelProvider;
        @Nullable
        private Function<IAlleleTreeSpecies, ILeafProvider> leafProvider;
        private ILeafSpriteProvider leafSpriteProvider;
        private PlantType nativeType = PlantType.PLAINS;
        private IGrowthProvider growthProvider = new ClimateGrowthProvider();
        private float rarity = 0.0f;

        public Builder(String modId, String uid, String speciesIdentifier) {
            super(modId, uid, speciesIdentifier);
        }

        protected static void checkBuilder(Builder builder) {
            AlleleForestrySpecies.AbstractBuilder.checkBuilder(builder);
            Preconditions.checkNotNull((Object)builder.generator);
            Preconditions.checkNotNull((Object)builder.germlingModelProvider);
            Preconditions.checkNotNull((Object)builder.leafSpriteProvider);
        }

        @Override
        public IAlleleTreeSpeciesBuilder cast() {
            return this;
        }

        @Override
        public IAlleleTreeSpecies build() {
            Builder.checkBuilder(this);
            return new AlleleTreeSpecies(this);
        }

        @Override
        public IAlleleTreeSpeciesBuilder setGenerator(ITreeGenerator generator) {
            this.generator = generator;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setModel(IGermlingModelProvider germlingModelProvider) {
            this.germlingModelProvider = germlingModelProvider;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setLeaf(Function<IAlleleTreeSpecies, ILeafProvider> leafProvider) {
            this.leafProvider = leafProvider;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setLeafSprite(ILeafSpriteProvider leafSpriteProvider) {
            this.leafSpriteProvider = leafSpriteProvider;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder addFruitFamily(IFruitFamily family) {
            this.fruits.add((Object)family);
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setPlantType(PlantType type) {
            this.nativeType = type;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setRarity(float rarity) {
            this.rarity = rarity;
            return this;
        }

        @Override
        public IAlleleTreeSpeciesBuilder setGrowthProvider(IGrowthProvider growthProvider) {
            this.growthProvider = growthProvider;
            return this;
        }
    }
}

