/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.items.ItemBlockForestry;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlockLeaves
extends ItemBlockForestry<BlockAbstractLeaves>
implements IColoredItem {
    public ItemBlockLeaves(BlockAbstractLeaves block) {
        super(block);
    }

    public ITextComponent func_200295_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return new TranslationTextComponent("trees.grammar.leaves.type");
        }
        TileLeaves tileLeaves = new TileLeaves();
        tileLeaves.func_230337_a_(tileLeaves.func_195044_w(), itemstack.func_77978_p());
        ITree tree = tileLeaves.getTree();
        if (tree == null) {
            return new TranslationTextComponent("for.leaves.corrupted");
        }
        return ItemBlockLeaves.getDisplayName(tree);
    }

    public static ITextComponent getDisplayName(ITree tree) {
        IAlleleTreeSpecies primary = (IAlleleTreeSpecies)tree.getGenome().getPrimary();
        String customTreeKey = "for.trees.custom.leaves." + primary.getSpeciesIdentifier();
        return Translator.tryTranslate(customTreeKey, () -> {
            TranslationTextComponent leaves = new TranslationTextComponent("for.trees.grammar.leaves.type");
            return new TranslationTextComponent("for.trees.grammar.leaves", new Object[]{primary.getDisplayName(), leaves});
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int renderPass) {
        if (itemStack.func_77978_p() == null) {
            return ModuleArboriculture.proxy.getFoliageColorDefault();
        }
        TileLeaves tileLeaves = new TileLeaves();
        tileLeaves.func_230337_a_(tileLeaves.func_195044_w(), itemStack.func_77978_p());
        if (renderPass == 2) {
            return tileLeaves.getFruitColour();
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return tileLeaves.getFoliageColour((PlayerEntity)player);
    }
}

