/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.loot;

import com.google.gson.JsonObject;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IFruitBearer;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.genetics.TreeHelper;
import genetics.api.individual.IGenome;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.ForgeEventFactory;

public class GrafterLootModifier
extends LootModifier {
    public static final Serializer SERIALIZER = new Serializer();

    public GrafterLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (state == null || !state.func_235714_a_((ITag)BlockTags.field_206952_E)) {
            return generatedLoot;
        }
        ItemStack harvestingTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (harvestingTool == null || harvestingTool.func_190926_b()) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(entity instanceof PlayerEntity)) {
            return generatedLoot;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (generatedLoot.stream().noneMatch(stack -> stack.func_77973_b().func_206844_a((ITag)ItemTags.field_200037_g))) {
            this.handleLoot(generatedLoot, player, harvestingTool, state, context);
        }
        harvestingTool.func_96631_a(1, context.func_216032_b(), (ServerPlayerEntity)player);
        if (harvestingTool.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)harvestingTool, (Hand)Hand.MAIN_HAND);
        }
        return generatedLoot;
    }

    public void handleLoot(List<ItemStack> generatedLoot, PlayerEntity player, ItemStack harvestingTool, BlockState state, LootContext context) {
        IGenome genome;
        IFruitProvider fruitProvider;
        World world = player.field_70170_p;
        TileEntity tileEntity = (TileEntity)context.func_216031_c(LootParameters.field_216288_h);
        ITree tree = this.getTree(state, tileEntity);
        if (tree == null) {
            return;
        }
        Vector3d origin = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
        if (origin == null) {
            return;
        }
        BlockPos pos = new BlockPos(origin);
        Item item = harvestingTool.func_77973_b();
        float saplingModifier = 1.0f;
        if (item instanceof IToolGrafter) {
            saplingModifier = ((IToolGrafter)item).getSaplingModifier(harvestingTool, world, player, pos);
        }
        List<ITree> saplings = tree.getSaplings(world, player.func_146103_bH(), pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            generatedLoot.add(TreeManager.treeRoot.getTypes().createStack(sapling, EnumGermlingType.SAPLING));
        }
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer bearer = (IFruitBearer)tileEntity;
            generatedLoot.addAll((Collection<ItemStack>)bearer.pickFruit(harvestingTool));
        }
        if (state.func_177230_c() instanceof BlockDefaultLeavesFruit && (fruitProvider = (genome = tree.getGenome()).getActiveAllele(TreeChromosomes.FRUITS).getProvider()).isFruitLeaf(genome, (IWorld)world, pos)) {
            generatedLoot.addAll((Collection<ItemStack>)tree.produceStacks(world, pos, Integer.MAX_VALUE));
        }
    }

    @Nullable
    private ITree getTree(BlockState state, @Nullable TileEntity entity) {
        ITreeRoot root = TreeHelper.getRoot();
        ITree tree = root.translateMember(state).orElse(null);
        if (tree != null || entity == null) {
            return tree;
        }
        return TreeHelper.getRoot().getTree(entity);
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<GrafterLootModifier> {
        public Serializer() {
            this.setRegistryName("forestry", "grafter_modifier");
        }

        public GrafterLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new GrafterLootModifier(conditions);
        }

        public JsonObject write(GrafterLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

