/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumLeafType;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public class TextureLeaves {
    private static final Map<EnumLeafType, TextureLeaves> leafTextures = new EnumMap<EnumLeafType, TextureLeaves>(EnumLeafType.class);
    private final ResourceLocation plain;
    private final ResourceLocation fancy;
    private final ResourceLocation pollinatedPlain;
    private final ResourceLocation pollinatedFancy;

    public static TextureLeaves get(EnumLeafType leafType) {
        return leafTextures.get((Object)leafType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerAllSprites(TextureStitchEvent.Pre event) {
        for (TextureLeaves leafTexture : leafTextures.values()) {
            leafTexture.registerSprites(event);
        }
    }

    private TextureLeaves(EnumLeafType enumLeafType) {
        String ident = enumLeafType.toString().toLowerCase(Locale.ENGLISH);
        this.plain = new ResourceLocation("forestry", "block/leaves/" + ident + ".plain");
        this.fancy = new ResourceLocation("forestry", "block/leaves/" + ident + ".fancy");
        this.pollinatedPlain = new ResourceLocation("forestry", "block/leaves/" + ident + ".changed.plain");
        this.pollinatedFancy = new ResourceLocation("forestry", "block/leaves/" + ident + ".changed");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerSprites(TextureStitchEvent.Pre event) {
        event.addSprite(this.plain);
        event.addSprite(this.fancy);
        event.addSprite(this.pollinatedPlain);
        event.addSprite(this.pollinatedFancy);
    }

    public ResourceLocation getSprite(boolean pollinated, boolean fancy) {
        if (pollinated) {
            if (fancy) {
                return this.pollinatedFancy;
            }
            return this.pollinatedPlain;
        }
        if (fancy) {
            return this.fancy;
        }
        return this.plain;
    }

    static {
        for (EnumLeafType leafType : EnumLeafType.values()) {
            leafTextures.put(leafType, new TextureLeaves(leafType));
        }
    }
}

