/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.FeatureArboriculture;
import forestry.core.utils.WorldUtils;
import forestry.core.worldgen.FeatureBase;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileSapling
extends TileTreeContainer {
    public static final ModelProperty<IAlleleTreeSpecies> TREE_SPECIES = new ModelProperty();
    private int timesTicked = 0;

    public TileSapling() {
        super(ArboricultureTiles.SAPLING.tileType());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.timesTicked = compoundNBT.func_74762_e("TT");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        compoundNBT.func_74768_a("TT", this.timesTicked);
        return compoundNBT;
    }

    @Override
    public void onBlockTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        ++this.timesTicked;
        this.tryGrow(rand, false);
    }

    private static int getRequiredMaturity(World world, ITree tree) {
        ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode((IWorld)world);
        float maturationModifier = treekeepingMode.getMaturationModifier(tree.getGenome(), 1.0f);
        return Math.round((float)tree.getRequiredMaturity() * maturationModifier);
    }

    public boolean canAcceptBoneMeal(Random rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            return true;
        }
        Feature<NoFeatureConfig> generator = tree.getTreeGenerator((ISeedReader)WorldUtils.asServer((IWorld)this.field_145850_b), this.func_174877_v(), true);
        if (generator instanceof FeatureArboriculture) {
            FeatureArboriculture arboricultureGenerator = (FeatureArboriculture)generator;
            arboricultureGenerator.preGenerate((IWorld)this.field_145850_b, rand, this.func_174877_v());
            return arboricultureGenerator.getValidGrowthPos((IWorld)this.field_145850_b, this.func_174877_v()) != null;
        }
        return true;
    }

    public void tryGrow(Random random, boolean bonemealed) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            if (bonemealed) {
                this.timesTicked = maturity;
            }
            return;
        }
        Feature<NoFeatureConfig> generator = tree.getTreeGenerator((ISeedReader)WorldUtils.asServer((IWorld)this.field_145850_b), this.func_174877_v(), bonemealed);
        boolean generated = generator instanceof FeatureBase ? ((FeatureBase)generator).place((IWorld)this.field_145850_b, random, this.func_174877_v(), false) : generator.func_241855_a((ISeedReader)((ServerWorld)this.field_145850_b), ((ServerChunkProvider)this.field_145850_b.func_72863_F()).func_201711_g(), random, this.func_174877_v(), (IFeatureConfig)IFeatureConfig.field_202429_e);
        if (generated) {
            IArboristTracker breedingTracker = TreeManager.treeRoot.getBreedingTracker((IWorld)this.field_145850_b, this.getOwnerHandler().getOwner());
            breedingTracker.registerBirth(tree);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        ITree tree = this.getTree();
        if (tree == null) {
            return EmptyModelData.INSTANCE;
        }
        return new ModelDataMap.Builder().withInitial(TREE_SPECIES, (Object)tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES)).build();
    }
}

