/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureBaobab
extends FeatureTree {
    public FeatureBaobab(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height - 1, this.girth, 0, 0.0f, null, 0.0f);
        if (rand.nextFloat() < 0.3f) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, wood, startPos.func_177982_a(0, this.height - 1, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, TreeContour.EMPTY);
        } else if (rand.nextBoolean()) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, wood, startPos.func_177982_a(0, this.height - 1, this.girth / 2), this.girth, this.girth - 1, 1, FeatureHelper.EnumReplaceMode.SOFT, TreeContour.EMPTY);
        }
        return FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, this.height - 2, 0), this.girth, 0.0f, 0.5f, 4, 6, 1.0f);
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int times;
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(world, leaf, branchEnd, this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        for (times = 0; times < this.height / 2; ++times) {
            int h = this.height - 1 + rand.nextInt(4);
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + rand.nextInt(2 * this.girth);
            int y_off = -this.girth + rand.nextInt(2 * this.girth);
            BlockPos center = startPos.func_177982_a(x_off, h, y_off);
            int radius = 1;
            if (this.girth > 1) {
                radius += rand.nextInt(this.girth - 1);
            }
            FeatureHelper.generateSphere(world, center, radius, leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        for (times = 0; times < this.height / 4; ++times) {
            int delim;
            int h = delim + ((delim = this.modifyByHeight(world, 6, 0, this.height)) < this.height ? rand.nextInt(this.height - delim) : 0);
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = -1 + rand.nextInt(3);
            int y_off = -1 + rand.nextInt(3);
            BlockPos center = startPos.func_177982_a(x_off, h, y_off);
            int radius = 1 + rand.nextInt(2);
            FeatureHelper.generateSphere(world, center, radius, leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

