/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.render.ParticleRender;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="forestry", value={Dist.CLIENT})
public class ClimateHandlerClient {
    private static IClimateState currentState = ClimateStateHelper.INSTANCE.absent();

    public static void setCurrentState(IClimateState currentState) {
        ClimateHandlerClient.currentState = currentState;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.CLIENT) {
            return;
        }
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        BlockPos pos = player.func_233580_cy_();
        if (currentState.isPresent()) {
            int x = world.field_73012_v.nextInt(11) - 5;
            int y = world.field_73012_v.nextInt(5) - 1;
            int z = world.field_73012_v.nextInt(11) - 5;
            ParticleRender.addClimateParticles(world, pos.func_177982_a(x, y, z), world.field_73012_v, currentState.getTemperatureEnum(), currentState.getHumidityEnum());
        }
    }
}

