/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    protected long previousMessageTick = 0L;

    protected BlockStructure(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.0f));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (playerIn.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((IBlockReader)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return ActionResultType.FAIL;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            if (controller != null) {
                String validationError;
                if (!controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                    long tick = worldIn.func_82737_E();
                    if (tick > this.previousMessageTick + 20L) {
                        playerIn.func_145747_a((ITextComponent)new StringTextComponent(validationError), Util.field_240973_b_);
                        this.previousMessageTick = tick;
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("for.multiblock.error.notConnected"), Util.field_240973_b_);
                return ActionResultType.SUCCESS;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            part.openGui((ServerPlayerEntity)playerIn, pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (placer instanceof PlayerEntity) {
            TileUtil.actOnTile((IWorldReader)world, pos, MultiblockTileEntityForestry.class, tile -> {
                PlayerEntity player = (PlayerEntity)placer;
                GameProfile gameProfile = player.func_146103_bH();
                tile.setOwner(gameProfile);
            });
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileUtil.actOnTile((IWorldReader)world, pos, IMultiblockComponent.class, tile -> {
            if (MultiblockUtil.getNeighboringParts(world, tile).isEmpty()) {
                if (tile instanceof IInventory) {
                    InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
                }
                if (tile instanceof ISocketable) {
                    InventoryUtil.dropSockets((ISocketable)((Object)tile), world, pos);
                }
            }
        });
        super.func_180657_a(world, player, pos, state, te, stack);
    }
}

